] /*                                                                  History module for libwww 1                                         HTHISTORY -                                               U    This is a simple history module for a WWW client.  It keeps a linear history, with J    destructive backtrack, and list sequencing (previous, next) operations.     V    If you are building a client, you don't have to use this: just don't call it.  ThisY    module is not used by any other modules in the libwww, so if you don't refer to it you +    don't get it in your linked application.        */  #ifndef HTHISTORY_H  #define HTHISTORY_H    #include "HTFormat.h"  #include "HTAnchor.h"    #ifdef SHORT_NAMES0 #define HTHistory_record                HTHiReco0 #define HTHistory_backtrack             HTHiBack0 #define HTHistory_canBacktrack          HTHiCaBa0 #define HTHistory_moveBy                HTHiMoBy0 #define HTHistory_canMoveBy             HTHiCaMo0 #define HTHistory_read                  HTHiRead0 #define HTHistory_recall                HTHiReca0 #define HTHistory_count                 HTHiCoun0 #define HTHistory_leavingFrom           HTHiLeFr #endif  * /*                              Navigation* **                              ========== */  , /*              Record the jump to an anchor, **              ---------------------------- */   extern void HTHistory_record	   PARAMS(      (HTAnchor * destination)   );  ? /*              Go back in history (find the last visited node) " **              ------------------ */  % extern HTAnchor * HTHistory_backtrack ;   NOPARAMS;  /* FIXME: Should we add a `sticky' option ? */   " extern BOOL HTHistory_canBacktrack   NOPARAMS;   A /*              Browse through references in the same parent node A **              -------------------------------------------------  **O **      Take the n-th child's link after or before the one we took to get here. F **      Positive offset means go towards most recently added children. */  " extern HTAnchor * HTHistory_moveBy	   PARAMS(       (int offset)       );    extern BOOL HTHistory_canMoveBy 	   PARAMS(       (int offset)       );   . #define HTHistory_next (HTHistory_moveBy (+1))4 #define HTHistory_canNext (HTHistory_canMoveBy (+1))2 #define HTHistory_previous (HTHistory_moveBy (-1))8 #define HTHistory_canPrevious (HTHistory_canMoveBy (-1))    ) /*                              Retrieval ) **                              =========  */  > /*              Read numbered visited anchor (1 is the oldest), **              ---------------------------- */    extern HTAnchor * HTHistory_read	   PARAMS(      (int number)   );  @ /*              Recall numbered visited anchor (1 is the oldest). **              ------------------------------N **      This reads the anchor and stores it again in the list, except if last. */  " extern HTAnchor * HTHistory_recall	   PARAMS(      (int number)   );  ( /*              Number of Anchors stored( **              ------------------------ **I **      This is needed in order to check the validity of certain commands  **      for menus, etc. , (not needed for now. Use canBacktrack, etc.)$ extern int HTHistory_count NOPARAMS; */  ) /*              Change last history entry ) **              -------------------------  **G **      Sometimes we load a node by one anchor but leave by a different F **      one, and it is the one we left from which we want to remember. */! extern void HTHistory_leavingFrom 	   PARAMS(      (HTAnchor * anchor)    );   #endif /* HTHISTORY_H */   /*       */