] /*                                                HTChunk: Flexible array handling for libwww <                              CHUNK HANDLING: FLEXIBLE ARRAYS-                                               X    This module implements a flexible array. It is a general utility module. A chunk is aU    structure which may be extended.  These routines create and append data to chunks, W    automatically reallocating them as necessary. It is garanteed that the array is '\0' Q    terminated at all times, so the terminating function, HTChunkTerminate is only :    necessary to get the right size in the chunk structure.       */    #ifndef HTCHUNK_H  #define HTCHUNK_H  /*    */  typedef struct {B         int     size;           /* In bytes                     */B         int     growby;         /* Allocation unit in bytes     */B         int     allocated;      /* Current size of *data        */C         char *  data;           /* Pointer to malloced area or 0 */ 
 } HTChunk;     #ifdef SHORT_NAMES( #define HTChunkClear            HTChClea( #define HTChunkPutc             HTChPutc( #define HTChunkPuts             HTChPuts( #define HTChunkCreate           HTChCrea( #define HTChunkTerminate        HTChTerm( #define HTChunkEnsure           HtChEnsu #endif     /*   Create new chunk     ON ENTRY,    U   growby                  The number of bytes to allocate at a time when the chunk is T                          later extended. Arbitrary but normally a trade-off time vs.                          memory                            
   ON EXIT,   ;   returns                 A chunk pointer to the new chunk,                              */   4 extern HTChunk * HTChunkCreate PARAMS((int growby));     /*   Free a chunk     ON ENTRY,    G   ch                      A valid chunk pointer made by HTChunkCreate()                            
   ON EXIT,   9   ch                      is invalid and may not be used.                              */   / extern void HTChunkFree PARAMS((HTChunk * ch));      /*  
 Clear a chunk      ON ENTRY,    G   ch                      A valid chunk pointer made by HTChunkCreate()                            
   ON EXIT,   8   *ch                     The size of the chunk is zero.                             */   0 extern void HTChunkClear PARAMS((HTChunk * ch));     /*  % Ensure a chunk has a certain space in      ON ENTRY,    G   ch                      A valid chunk pointer made by HTChunkCreate()                            +   s                       The size required                            
   ON EXIT,   -   *ch                     Has size at least s                              */   8 extern void HTChunkEnsure PARAMS((HTChunk * ch, int s));     /*   Append a character to a  chunk     ON ENTRY,    G   ch                      A valid chunk pointer made by HTChunkCreate()                            6   c                       The character to be appended                           
   ON EXIT,   1   *ch                     Is one character bigger                              */ 7 extern void HTChunkPutc PARAMS((HTChunk * ch, char c));    /*   Append a string to a  chunk      ON ENTRY,    G   ch                      A valid chunk pointer made by HTChunkCreate()                            L   str                     Tpoints to a zero-terminated string to be appended                           
   ON EXIT,   2   *ch                     Is bigger by strlen(str)                             */     @ extern void HTChunkPuts PARAMS((HTChunk * ch, const char *str));     /*  # Append a zero character to a  chunk     */    /*     ON ENTRY,    G   ch                      A valid chunk pointer made by HTChunkCreate()                            
   ON EXIT,   1   *ch                     Is one character bigger                              */     4 extern void HTChunkTerminate PARAMS((HTChunk * ch));   #endif   /*  	    end */ 