   /* MODULE							HTAAUtil.c/ **		COMMON PARTS OF ACCESS AUTHORIZATION MODULE   **			FOR BOTH SERVER AND BROWSER **
 ** IMPORTANT: ; **	Routines in this module use dynamic allocation, but free 1 **	automatically all the memory reserved by them.  **7 **	Therefore the caller never has to (and never should) 1 **	free() any object returned by these functions.  **: **	Therefore also all the strings returned by this package: **	are only valid until the next call to the same function< **	is made. This approach is selected, because of the nature= **	of access authorization: no string returned by the package 5 **	needs to be valid longer than until the next call.  **5 **	This also makes it easy to plug the AA package in: 7 **	you don't have to ponder whether to free() something : **	here or is it done somewhere else (because it is always **	done somewhere else). **9 **	The strings that the package needs to store are copied 4 **	so the original strings given as parameters to AA; **	functions may be freed or modified with no side effects.  **9 **	The AA package does not free() anything else than what  **	it has itself allocated.  **8 **	AA (Access Authorization) package means modules which **	names start with HTAA.  ** ** AUTHORS: * **	AL	Ari Luotonen	luotonen@dxcern.cern.ch. **	MD 	Mark Donszelmann    duns@vxdeop.cern.ch ** ** HISTORY: = **	 8 Nov 93  MD	(VMS only) Added case insensitive comparison  **			in HTAA_templateCaseMatch ** ** ** BUGS: ** ** */   #include <string.h>  #include "HTUtils.h"% #include "tcp.h"	/* NETREAD() etc.	*/ , #include "HTAAUtil.h"	/* Implemented here	*/& #include "HTAssoc.h"	/* Assoc list		*/      /* PUBLIC						HTAAScheme_enum() **		TRANSLATE SCHEME NAME INTO **		A SCHEME ENUMERATION ** ** ON ENTRY:2 **	name		is a string representing the scheme name. ** ** ON EXIT: 4 **	returns		the enumerated constant for that scheme. */: PUBLIC HTAAScheme HTAAScheme_enum ARGS1(CONST char*, name) {       static char *upcased = NULL;     char *cur;  #     if (!name) return HTAA_UNKNOWN;         StrAllocCopy(upcased, name);     cur = upcased;     while (*cur) { 	*cur = TOUPPER(*cur); 	cur++;      }      ?     if      (!strncmp(upcased, "NONE", 4))	   return HTAA_NONE; A     else if (!strncmp(upcased, "BASIC", 5))	   return HTAA_BASIC; C     else if (!strncmp(upcased, "PUBKEY", 6))	   return HTAA_PUBKEY; K     else if (!strncmp(upcased, "KERBEROSV4", 10))  return HTAA_KERBEROS_V4; K     else if (!strncmp(upcased, "KERBEROSV5", 10))  return HTAA_KERBEROS_V5; $     else					   return HTAA_UNKNOWN; }       /* PUBLIC						HTAAScheme_name()# **			GET THE NAME OF A GIVEN SCHEME  ** ON ENTRY:, **	scheme		is one of the scheme enum values:, **			HTAA_NONE, HTAA_BASIC, HTAA_PUBKEY, ... ** ** ON EXIT: ( **	returns		the name of the scheme, i.e.# **			"None", "Basic", "Pubkey", ...  */6 PUBLIC char *HTAAScheme_name ARGS1(HTAAScheme, scheme) {      switch (scheme) { 5       case HTAA_NONE:		return "None";          break; 6       case HTAA_BASIC:		return "Basic";         break;7       case HTAA_PUBKEY:		return "Pubkey";        break; 8       case HTAA_KERBEROS_V4:	return "KerberosV4";	break;8       case HTAA_KERBEROS_V5:	return "KerberosV5";	break;7       case HTAA_UNKNOWN:	return "UNKNOWN";       break; (       default:			return "THIS-IS-A-BUG";     }  }       # /* PUBLIC						HTAA_templateMatch() - **		STRING COMPARISON FUNCTION FOR FILE NAMES * **		   WITH ONE WILDCARD * IN THE TEMPLATE ** NOTE:< **	This is essentially the same code as in HTRules.c, but it? **	cannot be used because it is embedded in between other code. = **	(In fact, HTRules.c should use this routine, but then this > **	 routine would have to be more sophisticated... why is life **	 sometimes so hard...)  ** ** ON ENTRY:7 **	template	is a template string to match the file name * **			agaist, may contain a single wildcard+ **			character * which matches zero or more  **			arbitrary characters.7 **	filename	is the filename (or pathname) to be matched  **			agaist the template.  ** ** ON EXIT: 2 **	returns		YES, if filename matches the template. **			NO, otherwise.  */= PUBLIC BOOL HTAA_templateMatch ARGS2(CONST char *, template,    				     CONST char *, filename) {      CONST char *p = template;      CONST char *q = filename; 
     int m;  !     if (!template || !filename) {  	if (TRACE) fprintf(stderr, : 			   "HTAA_templateMatch: invalid param: %s is NULL!!\n",, 			   (template ? "filename" : "template")); 	return NO;      }   H     for( ; *p  &&  *q  &&  *p == *q; p++, q++)	/* Find first mismatch */ 	; /* do nothing else */  @     if (!*p && !*q)	return YES;	/* Equally long equal strings */)     else if ('*' == *p) {		/* Wildcard */ & 	p++;				/* Skip wildcard character */= 	m = strlen(q) - strlen(p);	/* Amount to match to wildcard */ : 	if (m < 0) return NO;		/* No match, filename too short */7 	else {			/* Skip the matched characters and compare */ 7 	    if (strcmp(p, q+m))	return NO;	/* Tail mismatch */ 5 	    else                return YES;	/* Tail match */  	}     }	/* if wildcard */ 7     else		return NO;	/* Length or character mismatch */  }         & /* PUBLIC					HTAA_templateCaseMatch()- **		STRING COMPARISON FUNCTION FOR FILE NAMES < **	   WITH ONE WILDCARD * IN THE TEMPLATE (Case Insensitive) ** NOTE:B **	This is essentially the same code as in HTAA_templateMatch, butB **	it compares case insensitive (for VMS). Reason for this routineD **	is that HTAA_templateMatch gets called from several places, also C **	there where a case sensitive match is needed, so one cannot just 1 **	change the HTAA_templateMatch routine for VMS.  ** ** ON ENTRY:7 **	template	is a template string to match the file name * **			agaist, may contain a single wildcard+ **			character * which matches zero or more  **			arbitrary characters.7 **	filename	is the filename (or pathname) to be matched  **			agaist the template.  ** ** ON EXIT: 2 **	returns		YES, if filename matches the template. **			NO, otherwise.  */A PUBLIC BOOL HTAA_templateCaseMatch ARGS2(CONST char *, template,  $ 			        	 CONST char *, filename) {      CONST char *p = template;      CONST char *q = filename; 
     int m;  !     if (!template || !filename) {  	if (TRACE) fprintf(stderr, > 			   "HTAA_templateCaseMatch: invalid param: %s is NULL!!\n",, 			   (template ? "filename" : "template")); 	return NO;      }   Z     for( ; *p  &&  *q  &&  toupper(*p) == toupper(*q); p++, q++) /* Find first mismatch */ 	; /* do nothing else */  @     if (!*p && !*q)	return YES;	/* Equally long equal strings */)     else if ('*' == *p) {		/* Wildcard */ & 	p++;				/* Skip wildcard character */= 	m = strlen(q) - strlen(p);	/* Amount to match to wildcard */ : 	if (m < 0) return NO;		/* No match, filename too short */7 	else {			/* Skip the matched characters and compare */ < 	    if (strcasecomp(p, q+m))	return NO;	/* Tail mismatch */5 	    else                return YES;	/* Tail match */  	}     }	/* if wildcard */ 7     else		return NO;	/* Length or character mismatch */  }         + /* PUBLIC					HTAA_makeProtectionTemplate() . **		CREATE A PROTECTION TEMPLATE FOR THE FILES+ **		IN THE SAME DIRECTORY AS THE GIVEN FILE 2 **		(Used by server if there is no fancier way for3 **		it to tell the client, and by browser if server . **		didn't send WWW-ProtectionTemplate: field) ** ON ENTRY:/ **	docname	is the document pathname (from URL).  ** ** ON EXIT: 7 **	returns	a template matching docname, and other files  **		files in that directory. *** **		E.g.  /foo/bar/x.html  =>  /foo/bar/ *
 **						    ^ # **				Space only to prevent it from " **				being a comment marker here,# **				there really isn't any space.  */E PUBLIC char *HTAA_makeProtectionTemplate ARGS1(CONST char *, docname)  {      char *template = NULL;     char *slash = NULL;        if (docname) {! 	StrAllocCopy(template, docname);   	slash = strrchr(template, '/'); 	if (slash) slash++; 	else slash = template;  	*slash = (char)0; 	StrAllocCat(template, "*");     } %     else StrAllocCopy(template, "*");        if (TRACE) fprintf(stderr,= 		       "make_template: made template `%s' for file `%s'\n",  		       template, docname);       return template; }          /** ** Skip leading whitespace from *s forward */2 #define SKIPWS(s) while (*s==' ' || *s=='\t') s++;   /*: ** Kill trailing whitespace starting from *(s-1) backwords */L #define KILLWS(s) {char *c=s-1; while (*c==' ' || *c=='\t') *(c--)=(char)0;}    " /* PUBLIC						HTAA_parseArgList()2 **		PARSE AN ARGUMENT LIST GIVEN IN A HEADER FIELD ** ON ENTRY:! **	str	is a comma-separated list:  ** **			item, item, item 	 **		where  **			item ::= value  **			       | name=value **			       | name="value" **. **		Leading and trailing whitespace is ignored5 **		everywhere except inside quotes, so the following  **		examples are equal:  ** **			name=value,foo=bar  **			 name="value",foo="bar"  **			  name = value ,  foo = bar% **			   name = "value" ,  foo = "bar"  ** ** ON EXIT: > **	returns	a list of name-value pairs (actually HTAssocList*).3 **		For items with no name, just value, the name is 1 **		the number of order number of that item. E.g.  **		"1" for the first, etc.  */8 PUBLIC HTAssocList *HTAA_parseArgList ARGS1(char *, str) { 0     HTAssocList *assoc_list = HTAssocList_new();     char *cur = NULL;      char *name = NULL;     int index = 0;        if (!str) return assoc_list;       while (*str) {. 	SKIPWS(str);				/* Skip leading whitespace */ 	cur = str; 	 	index++;   / 	while (*cur  &&  *cur != '='  &&  *cur != ',') C 	    cur++;	/* Find end of name (or lonely value without a name) */ , 	KILLWS(cur);	/* Kill trailing whitespace */  4 	if (*cur == '=') {			/* Name followed by a value *// 	    *(cur++) = (char)0;			/* Terminate name */  	    StrAllocCopy(name, str); 3 	    SKIPWS(cur);			/* Skip WS leading the value */  	    str = cur; , 	    if (*str == '"') {			/* Quoted value */ 		str++; 		cur = str;& 		while (*cur  &&  *cur != '"') cur++; 		if (*cur == '"')/ 		    *(cur++) = (char)0;	/* Terminate value */ , 		/* else it is lacking terminating quote */, 		SKIPWS(cur);			/* Skip WS leading comma */6 		if (*cur == ',') cur++;		/* Skip separating colon */ 	    }# 	    else {				/* Unquoted value */ & 		while (*cur  &&  *cur != ',') cur++;/ 		KILLWS(cur);			/* Kill trailing whitespace */  		if (*cur == ',') 		    *(cur++) = (char)0;  		/* else *cur already NULL */ 	    } 	}# 	else {	/* No name, just a value */  	    if (*cur == ',') , 		*(cur++) = (char)0;		/* Terminate value */? 	    /* else last value on line (already terminated by NULL) */ @ 	    StrAllocCopy(name, "nnn");	/* Room for item order number */A 	    sprintf(name, "%d", index); /* Item order number for name */  	}( 	HTAssocList_add(assoc_list, name, str); 	str = cur;      } /* while *str */,     FREE(name);						  /* Henrik 14/03-94 */     return assoc_list; }             