9 /*                                    GROUP FILE ROUTINES -                                                 */    #ifndef HTGROUP_H  #define HTGROUP_H    #include "HTUtils.h", #include "HTAAUtil.h"   /* HTAAFailReason */ #include "HTList.h"  #include "HTWild.h"    #ifdef SHORT_NAMES* #define HTAApGrD        HTAA_parseGroupDef3 #define HTAArGrR        HTAA_resolveGroupReferences * #define HTAApGrD        HTAA_printGroupDef' #define HTAAGD_d        GroupDef_delete / #define HTAAuIIG        HTAA_userAndInetInGroup  #endif /* SHORT_NAMES */   typedef HTList GroupDefList; typedef HTList ItemList;   typedef struct {     char *      group_name;      ItemList *  item_list; } GroupDef;      /*   Group definition grammar     string>                          "sequence of alphanumeric characters"                              user_name                           string                               group_name                          string                               group_ref #                          group_name                            
   user_def.                          user_name | group_ref                              user_def_list 4                            user_def { ',' user_def }                              user_part 9                          user_def | '(' user_def_list ')'                               templ                            G                          "sequence of alphanumeric characters and '*'s"                               ip_number_mask<                          templ '.' templ '.' templ '.' templ                              domain_name_mask,                          templ { '.' templ }                           	   address                            :                          ip_number_mask | domain_name_mask                           
   address_def                                                       address                              address_def_list8                          address_def { ',' address_def }                              address_part?                          address_def | '(' address_def_list ')'                               item7                          [user_part] ['@' address_part]                               item_list *                          item { ',' item }                              group_def "                          item_list                              group_decl1                          group_name ':' group_def                               PARSE GROUP DEFINITION     */   8 PUBLIC GroupDef *HTAA_parseGroupDef PARAMS((FILE * fp)); /*  F Fill in Pointers to referenced Group Definitions in a Group Definition  X    References to groups (by their name) are resolved from group_def_list and pointers to+    those structures are added to group_def.        */   I PUBLIC void HTAA_resolveGroupReferences PARAMS((GroupDef *     group_def, P                                                 GroupDefList * group_def_list)); /*    Read Group File (and do caching)  Z    If group file is already in cache returns a pointer to previously read group definition    list.       */   H PUBLIC GroupDefList *HTAA_readGroupFile PARAMS((CONST char * filename)); /*   Delete Group Definition   V    Groups in cache should never be freed by this function. This should only be used to5    free group definitions read by HTAA_parseGroupDef.        */   ; PUBLIC void GroupDef_delete PARAMS((GroupDef * group_def));  /*  / Print Out Group Definition (for trace purposes)     */   > PUBLIC void HTAA_printGroupDef PARAMS((GroupDef * group_def)); /*  + Does a User Belong to a Given Set of Groups   C    This function checks both the username and the internet address.        */   I /* PUBLIC                                       HTAA_userAndInetInGroup() 9 **              CHECK IF USER BELONGS TO TO A GIVEN GROUP 5 **              AND THAT THE CONNECTION COMES FROM AN 5 **              ADDRESS THAT IS ALLOWED BY THAT GROUP  ** ON ENTRY:7 **      group           the group definition structure. ( **      username        connecting user.9 **      ip_number       browser host IP number, optional. 7 **      ip_name         browser host IP name, optional. < **                      However, one of ip_number or ip_name& **                      must be given. ** ON EXIT: < **      returns         HTAA_IP_MASK, if IP address mask was+ **                      reason for failing. @ **                      HTAA_NOT_MEMBER, if user does not belong% **                      to the group. C **                      HTAA_OK if both IP address and user are ok.  */G PUBLIC HTAAFailReason HTAA_userAndInetInGroup PARAMS((GroupDef * group, J                                                       char *     username,K                                                       char *     ip_number, K                                                       char *     ip_name)); 4 PUBLIC BOOL HTIpMaskMatch PARAMS((HTPattern *   pat,:                                   CONST char *  ip_number,:                                   CONST char *  ip_name)); /*    */    #endif /* not HTGROUP_H */ /*      End of file HTGroup.h.  */ 