   /*								HTConfig.h%  *	Configuration system of CERN httpd   *3  *	Ari Luotonen, CERN, 1994, <luotonen@www.cern.ch>   *  *  */    #ifndef HTCONFIG_H #define HTCONFIG_H   #include "HTUtils.h" #include "HTList.h"  #include "HTAccess.h"  #include "HTWild.h"  #include "HTRules.h" #include "HTAAProt.h"     2 #define DEFAULT_INPUT_TIMEOUT	 120	  /*  2 mins */3 #define DEFAULT_OUTPUT_TIMEOUT	1200	  /* 20 mins */ 3 #define DEFAULT_SCRIPT_TIMEOUT	 300	  /*  5 mins */ I #define DEFAULT_CLEANUP_TIMEOUT   15	  /* 15 secs to write to log file */ J #define DEFAULT_CACHE_LM_FACTOR	 0.1	  /* 10% of the time last-modified */= #define DEFAULT_REFRESH_INTERVAL 1200000  /* About 2 weeks */    typedef struct _HTRule {     struct _HTRule *	next;     HTRuleOp		op;      HTPattern *		pat;      HTPattern *		eqv;      HTUidGid *		ids;     char *		prot_file;     HTAAProt *		prot_setup; 	 } HTRule;    typedef enum {"     SERVER_TYPE_UNINITIALIZED = 0,     SERVER_TYPE_STANDALONE,      SERVER_TYPE_INETD 
 } HTServType;     typedef struct _HTServerConfig {1     char *	hostname;		/* Used for CGI scripts		*/ 7     HTServType	server_type;		/* Standalone or inetd		*/ 1     int		port;			/* Default port number string	*/ 0     BOOL	no_bg;			/* Don't auto-go background	*/-     BOOL	standalone;		/* Am I standalone?		*/ 8     char *	server_root;		/* Server's "home directory"	*/5     int		security_level;		/* 0 = normal, 1 = high		*/ 7     BOOL	icons_inited;		/* If not we'll use defaults	*/ :     int		input_timeout;		/* Timeout for reading request	*/<     int		output_timeout;		/* Timeout for sending response	*/4     int		script_timeout;		/* Timeout for scripts		*/8     char *	pid_file;		/* File to write the pid number	*/:     BOOL	do_accept_hack;		/* Send even if not Accept'ed	*/8     BOOL	disabled[MAX_METHODS+1];/* Disabled methods		*/4     BOOL	do_setuid;		/* Do setuid() to auth'd uid	*/>     int		max_content_len_buf;	/* How much to buffer for c-l	*/7     HTList *	no_log;			/* Hosts for which no logging	*/ ?     BOOL	new_logfile_format;	/* Use new common logfile format*/ 5     BOOL	use_gmt;		/* Use GMT instead of localtime	*/ 8     char *	user_dir;		/* User supported directory name*/+     char *	user_id;		/* Default user id		*/ -     char *	group_id;		/* Default group id		*/ 8     char *	parent_uid;		/* User id for parent process	*/9     char *	parent_gid;		/* Group id for parent process	*/ 7     BOOL	do_rfc931;		/* Should we check remote ident	*/ :     BOOL	do_dns_lookup;		/* Get the DNS name for client	*/7     BOOL	do_linger;		/* Is lingering really necessary*/ 3     char *	meta_dir;		/* Directory for metafiles	*/ 4     char *	meta_suffix;		/* Suffix for metafiles		*/;     BOOL	always_welcome;		/* Redirect directory names to	*/ $ 					/* welcome page on that dir.	*/7     char *	access_log_name;	/* Access log file name		*/ <     char *	proxy_log_name;		/* Proxy access log file name	*/<     char *	cache_log_name;		/* Cache access log file name	*/6     char *	error_log_name;		/* Error log file name		*/4     BOOL	reloading;		/* Are we now reloding rules	*/8     HTList *	rule_files;		/* All loaded files by name	*/ } HTServerConfig;   " typedef struct _HTResourceConfig {2     HTRule *	rule_head;		/* Rules (first rule)		*/*     HTRule *	rule_tail;		/* Last rule			*/9     HTList *	named_prots;		/* Named protections setups	*/ 5     char *	search_script;		/* Search script name.		*/ 3     char *	put_script;		/* Script to handle PUT		*/ 4     char *	post_script;		/* Script to handle POST	*/8     char *	delete_script;		/* Script to handle DELETE	*/ } HTResourceConfig;    typedef struct _HTPatTime {      HTPattern *		pat;      time_t		time;      struct _HTPatTime *	next; G     struct _HTPatTime *	last;	/* Only set for the first node in list	*/  } HTPatTime;   typedef struct _HTPatFact {      HTPattern *		pat;      float		factor;     struct _HTPatFact *	next; G     struct _HTPatFact *	last;	/* Only set for the first node in list	*/  } HTPatFact;   typedef struct _HTCacheConfig { ;     BOOL	caching_explicitly_off;	/* Is caching disabled		*/ 9     char *	cache_root;		/* Cache directory for gateway	*/ <     HTList *	no_caching;		/* No caching if matching these	*/<     HTList *	cache_only;		/* Cache only if matching these	*/@     HTPatTime *	cache_clean;		/* Remove always after this time*/>     time_t	cache_clean_def;	/* (by template and a default).	*/A     HTPatTime *	cache_unused;		/* Remove after unused this long*/ ?     time_t	cache_unused_def;	/* (by template and a default).	*/ >     HTPatTime *	cache_exp;		/* Default expiry when not given*/=     time_t	cache_exp_def;		/* (by template and a default).	*/ B     HTPatTime *	cache_refresh_interval;	/* Force cache refresh		*/B     HTPatFact *	cache_lm_factors;	/* For approximating Expires:	*/9     long	cache_max_k;		/* Default size in K (5MB small)*/ 9     int		cache_max_f;		/* At most this many cache files*/ 9     int		cache_limit_1;		/* Size no problem until 200K	*/ 4     int		cache_limit_2;		/* No caching after 4MB		*/>     time_t	cache_time_margin;	/* Time accuracy (in seconds)	*/9     time_t	cache_lock_timeout;	/* Break hanging locks		*/ 8     BOOL	keep_expired;		/* Use the max cache capasity	*/.     BOOL	do_exp_check;		/* Do expiry check		*/6     BOOL	cache_no_connect;	/* Use only local cache		*/8     BOOL	gc_disabled;		/* Never do garbage collection	*/2     time_t	gc_daily_gc;		/* gc daily at 3:00am		*/:     int		gc_mem_usage_control;	/* How radical mem usage	*/ } HTCacheConfig;   /*@  *	Global variables for server, resource and cache configuration  */ 6 extern HTServerConfig	sc;		/* Server configuration		*/9 extern HTResourceConfig	rc;		/* Resource configuration	*/ ; extern HTCacheConfig	cc;		/* Cache & proxy configuration	*/      /*@  *	HTDefaultConfig() should be called in as the first thing when=  *	the server starts to initialize the default configuration.   */ % PUBLIC void HTDefaultConfig NOPARAMS;    /*.  *	Add rule to current resource configuration;-  *	this is NOT for Protect and DefProt rules, /  *	ONLY for Map, Pass, Fail, Exec, and Redirect   */ 2 PUBLIC HTRule * HTAppendRule PARAMS((HTRuleOp		op, 				     CONST char *	pattern, 				     CONST char *	equiv));   /*=  *	HTLoadConfig(filename) opens the configuration file, reads ;  *	and parses it, and memorizes the filename so that server $  *	restart can reload the same file.  */ 3 PUBLIC BOOL HTLoadConfig PARAMS((char * filename));    /*A  *	HTServerInit() does final server configuration initialization; 4  *	it initializes standard icons and open log files.  *A  *	After the first time functions as the server restart function, >  *	i.e. also reloads the configuration files, and re-opens all  *	the log files.   */ " PUBLIC BOOL HTServerInit NOPARAMS;     /*,  *	Translate request through the rule system  */ 5 PUBLIC BOOL HTTranslateReq PARAMS((HTRequest * req));    /*%  *	Utility functions for cache module   */ 6 PUBLIC time_t get_default_expiry PARAMS((char * url));. PUBLIC time_t get_unused PARAMS((char * url));- PUBLIC time_t get_clean PARAMS((char * url)); 8 PUBLIC time_t get_refresh_interval PARAMS((char * url));0 PUBLIC float get_lm_factor PARAMS((char * url));   #endif /* HTCONFIG_H */   