> /*                                ACCESS CONTROL LIST ROUTINES-                                                 */    #ifndef HTACL_H  #define HTACL_H    #include "HTUtils.h" #include "HTAAUtil.h"  #include "HTGroup.h" #include "HTAccess.h"      #ifdef SHORT_NAMES+ #define HTAAgAFn        HTAA_getAclFilename $ #define HTAAoACL        HTAA_openAcl% #define HTAAcACL        HTAA_closeAcl ( #define HTAAgAEn        HTAA_getAclEntry, #define HTAAgFAE        HTAA_getFullAclEntry #endif /* SHORT_NAMES */   typedef struct _HTACL {      HTList *    methods;     GroupDef *  groups;  } HTACL;     /*    Opening Access Control List File    */   F /* PUBLIC                                               HTAA_openAcl()8 **              OPEN THE ACL FILE FOR THE GIVEN DOCUMENT ** ON ENTRY:3 **      pathname        is the absolute pathname of 0 **                      the file to be accessed. ** ** ON EXIT: . **      returns         the FILE* to open ACL./ **                      NULL, if ACL not found.  */: PUBLIC FILE *HTAA_openAcl PARAMS((CONST char * pathname));    G /* PUBLIC                                               HTAA_closeAcl() & **                      CLOSE ACL FILE ** ON ENTRY:6 **      acl_file is Access Control List file to close. ** ** ON EXIT:  **      returns nothing. */4 PUBLIC void HTAA_closeAcl PARAMS((FILE * acl_file)); /*   Getting ACL Entry     */   J /* PUBLIC                                               HTAA_getAclEntry(); **                      CONSULT THE ACCESS CONTROL LIST AND 9 **                      GIVE A LIST OF GROUPS (AND USERS) 9 **                      AUTHORIZED TO ACCESS A GIVEN FILE  ** ON ENTRY:, **      acl_file        is an open ACL file.3 **      pathname        is the absolute pathname of 0 **                      the file to be accessed.A **      method          is the method for which access is wanted.  ** ** ALC FILE FORMAT:  **E **      template : method, method, ... : group@addr, user, group, ...  **> **      The last item is in fact in exactly the same format as< **      group definition in group file, i.e. everything that& **      follows the 'groupname:' part, **      e.g.9 **              user, group, user@address, group@address, 8 **              (user,group,...)@(address, address, ...) ** ** ON EXIT: K **      returns         NULL, if there is no entry for the file in the ACL, - **                      or ACL doesn't exist. E **                      If there is, a GroupDef object containing the G **                      group and user names allowed to access the file @ **                      is returned (this is automatically freed; **                      next time this function is called). 
 ** IMPORTANT: : **      Returns the first entry with matching template and= **      method. This function should be called multiple times A **      to process all the valid entries (until it returns NULL). ; **      This is because there can be multiple entries like:  **3 **              *.html : get,put : ari,timbl,robert : **              *.html : get     : jim,james,jonathan,jojo ** ** NOTE:A **      The returned group definition may well contain references C **      to groups defined in group file. Therefore these references @ **      must be resolved according to that rule file by function? **      HTAA_resolveGroupReferences() (group file is read in by A **      HTAA_readGroupFile()) and after that access authorization = **      can be checked with function HTAA_userAndInetGroup().  */A PUBLIC GroupDef *HTAA_getAclEntry PARAMS((FILE *        acl_file, A                                           CONST char *  pathname, A                                           HTMethod      method));   A PUBLIC HTACL * HTAA_getFullAclEntry PARAMS((FILE *      acl_file, C                                             CONST char* pathname));    /*    */    #endif /* not HTACL_H */ /*      End of file HTACL.h.  */ 