   /* MODULE							HTACL.c   **		ACCESS CONTROL LIST ROUTINES ** ** AUTHORS: * **	AL	Ari Luotonen	luotonen@dxcern.cern.ch. **	MD 	Mark Donszelmann    duns@vxdeop.cern.ch ** ** HISTORY: P **	 8 Nov 93  MD	(VMS only) case insensitive compare reading acl entry, filename ** ** ** BUGS: ** ** */     #include <stdio.h>	/* FILE */  #include <string.h>    #include "HTUtils.h") #include "HTAAFile.h"	/* File routines	*/ $ #include "HTGroup.h"	/* GroupDef		*/) #include "HTACL.h"	/* Implemented here	*/     $ /* PUBLIC						HTAA_getAclFilename()= **	    RESOLVE THE FULL PATHNAME OF ACL FILE FOR A GIVEN FILE  ** ON ENTRY:0 **	path	is the pathname of the file for which to **		ACL file should be found.  **) **		ACL filename is computed by replacing , **		the filename by .www_acl in the pathname. **		(this is done to a local copy, of course). ** ** ON EXIT: , **	returns	the absolute pathname of ACL file+ **		(which is automatically freed next time  **		this fuction is called). */> PUBLIC char *HTAA_getAclFilename ARGS1(CONST char *, pathname) { $     static char * local_copy = NULL;"     static char * acl_path = NULL;     char * directory = NULL;     char * filename = NULL;   C     StrAllocCopy(local_copy, pathname);	/* Also frees local_copy */ C                                         /* from previous call.   */        directory = local_copy; '     filename = strrchr(directory, '/'); 8     if (!filename) {		/* No path in front of filename */0 	directory = ".";	/* So use current directory */E 	filename = local_copy;	/* and the pathname itself is the filename */      } 
     else {B 	*filename = '\0'; /* Truncate filename off from directory path */D 	filename++;	  /* and the filename begins from the next character */     }      @     StrAllocCopy(acl_path, directory);	/* Also frees acl_path */A                                         /* from previous call. */      StrAllocCat(acl_path, "/"); )     StrAllocCat(acl_path, ACL_FILE_NAME);        return acl_path; }      /* PUBLIC						HTAA_openAcl() , **		OPEN THE ACL FILE FOR THE GIVEN DOCUMENT ** ON ENTRY:' **	pathname	is the absolute pathname of  **			the file to be accessed.  ** ** ON EXIT: " **	returns		the FILE* to open ACL. **			NULL, if ACL not found. */7 PUBLIC FILE *HTAA_openAcl ARGS1(CONST char *, pathname)  {      if (pathname) 2 	return fopen(HTAA_getAclFilename(pathname), "r");
     else { 	CTRACE(stderr, = 	       "INTERNAL.... Trying to open ACL with NULL param\n"); 
 	return NULL;      }  }      /* PUBLIC						HTAA_closeAcl() **			CLOSE ACL FILE  ** ON ENTRY:1 **	acl_file is Access Control List file to close.  ** ** ON EXIT:  **	returns	nothing.  */1 PUBLIC void HTAA_closeAcl ARGS1(FILE *, acl_file)  { $     if (acl_file)  fclose(acl_file); }     ! /* PUBLIC						HTAA_getAclEntry() ( **			CONSULT THE ACCESS CONTROL LIST AND& **			GIVE A LIST OF GROUPS (AND USERS)& **			AUTHORIZED TO ACCESS A GIVEN FILE ** ON ENTRY:  **	acl_file	is an open ACL file.' **	pathname	is the absolute pathname of  **			the file to be accessed. 4 **	method		is the method for which access is wanted. ** ** ALC FILE FORMAT:  **@ **	template : method, method, ... : group@addr, user, group, ... **9 **	The last item is in fact in exactly the same format as 7 **	group definition in group file, i.e. everything that ! **	follows the 'groupname:' part,  **	e.g. - **		user, group, user@address, group@address, , **		(user,group,...)@(address, address, ...) ** ** ON EXIT: ? **	returns		NULL, if there is no entry for the file in the ACL,  **			or ACL doesn't exist.2 **			If there is, a GroupDef object containing the4 **			group and user names allowed to access the file- **			is returned (this is automatically freed ( **			next time this function is called).
 ** IMPORTANT: 5 **	Returns the first entry with matching template and 8 **	method. This function should be called multiple times< **	to process all the valid entries (until it returns NULL).6 **	This is because there can be multiple entries like: **' **		*.html : get,put : ari,timbl,robert + **		*.html : get	 : jim,james,jonathan,jojo  ** ** NOTE:< **	The returned group definition may well contain references> **	to groups defined in group file. Therefore these references; **	must be resolved according to that rule file by function : **	HTAA_resolveGroupReferences() (group file is read in by< **	HTAA_readGroupFile()) and after that access authorization8 **	can be checked with function HTAA_userAndInetGroup(). */: PUBLIC GroupDef *HTAA_getAclEntry ARGS3(FILE *,		acl_file, 					CONST char *,	pathname, 					HTMethod,	method) { '     static GroupDef * group_def = NULL;      CONST char * filename;     int len;     char *buf;  8     if (!acl_file) return NULL;		/* ACL doesn't exist */       if (!pathname || !method) {  	CTRACE(stderr, G 	       "INTERNAL.... invalid param for getAclEntry(): %s is NULL!!\n", , 	       (pathname ? "method" : "pathname"));
 	return NULL;      }        if (group_def) {5 	GroupDef_delete(group_def);	/* From previous call */  	group_def = NULL;     }   -     if (!(filename = strrchr(pathname, '/')))  	filename = pathname; %     else filename++;	/* Skip slash */        len = strlen(filename);   B     if (!(buf = (char*)malloc((strlen(filename)+2)*sizeof(char))))0 	outofmem(__FILE__, "HTAA_getAuthorizedGroups");     =     while (EOF != HTAAFile_readField(acl_file, buf, len+1)) { 
 #ifdef VMS- 	if (HTAA_templateCaseMatch(buf, filename)) {  #else /* not VMS */ ) 	if (HTAA_templateMatch(buf, filename)) {  #endif /* not VMS */$ 	    HTList *methods = HTList_new();> 	    HTAAFile_readList(acl_file, methods, MAX_METHODNAME_LEN); 	    CTRACE(stderr, E 	    "Info........ \"%s\" matched template \"%s\", allowed methods:",  		   filename, buf);@ 	    if (HTMethod_inList(method, methods)) {	/* right method? */ 		HTList * cur = methods;  		char * killme;    		/* Leak fixed AL 6 Feb 1994 */2 		while ((killme = (char*)HTList_nextObject(cur))) 		    free(killme);  		HTList_delete(methods);    		free(buf);+ 		group_def = HTAA_parseGroupDef(acl_file); ! 		CTRACE(stderr, " METHOD OK\n");  		/*2 		** HTAA_parseGroupDef() already reads the record3 		** separator so we don't call HTAAFile_nextRec().  		*/ 		return group_def;  	    } 	    else {  		HTList * cur = methods;  		char * killme;    		/* Leak fixed AL 6 Feb 1994 */2 		while ((killme = (char*)HTList_nextObject(cur))) 		    free(killme);  		HTList_delete(methods); ( 		CTRACE(stderr, " METHOD NOT FOUND\n"); 	    } 	}	/* if template match */ 	else { I 	    CTRACE(stderr, "Info........ \"%s\" didn't match template \"%s\"\n",  		   filename, buf); 	}   	HTAAFile_nextRec(acl_file);     }	/* while not eof */      free(buf);  2     return NULL;	/* No entry for requested file */9                         /* (or an empty entry).        */  }       ; PUBLIC HTACL * HTAA_getFullAclEntry ARGS2(FILE *,	acl_file,  					  CONST char *,	pathname) {      static HTACL entry;      CONST char * filename;     int len;     char *buf;  E     if (!acl_file || !pathname) return NULL;		/* ACL doesn't exist */   4     if (entry.methods) HTList_delete(entry.methods);!     entry.methods = HTList_new();        if (entry.groups) {  	GroupDef_delete(entry.groups);  	entry.groups = NULL;      }   -     if (!(filename = strrchr(pathname, '/')))  	filename = pathname; %     else filename++;	/* Skip slash */        len = strlen(filename);   ;     buf = (char*)malloc((strlen(filename)+2)*sizeof(char)); 9     if (!buf) outofmem(__FILE__, "HTAA_getFullAclEntry");      =     while (EOF != HTAAFile_readField(acl_file, buf, len+1)) { 
 #ifdef VMS- 	if (HTAA_templateCaseMatch(buf, filename)) {  #else /* not VMS */ ) 	if (HTAA_templateMatch(buf, filename)) {  #endif /* not VMS */  % 	    HTList * methods = HTList_new();  	    HTList * cur = methods; 	    char * str;   	    free(buf); > 	    HTAAFile_readList(acl_file, methods, MAX_METHODNAME_LEN);4 	    while ((str = (char*)HTList_nextObject(cur))) { 		char * s = str;  		while (*s) { 		    *s = TOUPPER(*s); 
 		    s++; 		} 3 		HTList_addObject(entry.methods, HTAtom_for(str));  		free(str); 	    } 	    HTList_delete(methods);1 	    entry.groups = HTAA_parseGroupDef(acl_file);  	    /* 5 	    ** HTAA_parseGroupDef() already reads the record 6 	    ** separator so we don't call HTAAFile_nextRec(). 	    */  	    return &entry;  	} 	HTAAFile_nextRec(acl_file);     }	/* while not eof */      free(buf);  2     return NULL;	/* No entry for requested file */9                         /* (or an empty entry).        */  }   