G /*                       FILE ROUTINES FOR ACCESS AUTHORIZATION PACKAGE -                                               Y    This module implements the routines used for accessing (and parsing) the files used in     the access authorization:            password file               group file       $       access control list (ACL) file         */      #ifndef HTAAFILE_H #define HTAAFILE_H  " #include <stdio.h>      /* FILE */8 #include "HTUtils.h"            /* BOOL, PARAMS, ARGS */, #include "HTList.h"             /* HTList */   #ifdef SHORT_NAMES( #define HTAAFnRe        HTAAFile_nextRec* #define HTAAFrFi        HTAAFile_readField) #define HTAAFrLi        HTAAFile_readList  #endif /*SHORT_NAMES*/     /* Used field separators */   J #define FIELD_SEPARATOR ':'     /* Used to separate fields              */J #define LIST_SEPARATOR  ','     /* Used to separate items in a list     */J                                 /* in group and ALC files.              */   /*   Naming conventions  3   Record                 is an entire line in file.                            P   Field                  is an entity separated by colons and/or by end-of-line.                           Q   List                   is a field in which there are items separated by commas.                             Record-oriented Read Routines   M    Password, group and ACL are internally read in by the following functions:      X   HTAAFile_nextRec()      skips to the beginning of the next record (must be called evenX                          after the last field of a record is read to proceed to the next!                          record).                            >   HTAAFile_readField()    reads a field (separated by colons).                           S   HTAAFile_readList()     reads a field containing a comma-separated list of items.                              */   J /* PUBLIC                                               HTAAFile_nextRec()> **                      GO TO THE BEGINNING OF THE NEXT RECORD ** ON ENTRY:= **      fp      is the file from which records are read from.  ** ** ON EXIT: F **      returns nothing. File read pointer is located at the beginning# **              of the next record.  ** */1 PUBLIC void HTAAFile_nextRec PARAMS((FILE * fp));     L /* PUBLIC                                               HTAAFile_readField()3 **              READ A FIELD FROM A PASSWORD, GROUP + **              OR ACCESS CONTROL LIST FILE 1 **              i.e. an item terminated by colon, , **              end-of-line, or end-of-file. ** ON ENTRY:? **      fp              is the file to read the characters from D **      contents        is the character array to put the charactersD **      max_len         is the maximum number of characters that mayD **                      be read (i.e. the size of dest minus one for* **                      terminating null). ** ON EXIT: 1 **      returns         the terminating character C **                      (i.e. either separator or CR or LF or EOF). F **      contents        contains a null-terminated string representing' **                      the read field. 
 ** NOTE 1:E **                      Ignores leading and trailing blanks and tabs. 
 ** NOTE 2:D **                      If the field is more than max_len charactersE **                      long, the rest of the characters in that item A **                      are ignored.  However, contents is always ( **                      null-terminated! */0 PUBLIC int HTAAFile_readField PARAMS((FILE * fp,6                                       char * contents,7                                       int    max_len));     K /* PUBLIC                                               HTAAFile_readList()  **B **                      READ A LIST OF STRINGS SEPARATED BY COMMASB **                      (FROM A GROUP OR ACCESS CONTROL LIST FILE) ** ON ENTRY:7 **      fp              is a pointer to the input file. C **      result          is the list to which append the read items. C **      max_len         is the maximum number of characters in each B **                      list entry (extra characters are ignored). ** ON EXIT: 1 **      returns         the number of items read.  ** */3 PUBLIC int HTAAFile_readList PARAMS((FILE *     fp, 7                                      HTList *   result, :                                      int        max_len)); /*    */    #endif /* not HTAAFILE_H */  /*      End of file HTAAFile.h.  */