/*
 * SAP Copyright (c) 2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/WDWindowUnitOfLength.java#2 $
 */
package com.sap.tc.webdynpro.services.session.api;

/**
 * WDWindowUnitOfLength
 * @author SAP
 * @SAPWebDynproPart 2
 *
 * this class defines constants for the positions/unit of length of an window instance.
 * @see com.sap.tc.webdynpro.services.session.api.IWDWindow setWindowPosition(WDWindowPos) for details
 */
public final class WDWindowUnitOfLength {
  public static final WDWindowUnitOfLength EM = new WDWindowUnitOfLength("em");
  public static final WDWindowUnitOfLength EX = new WDWindowUnitOfLength("ex");
  public static final WDWindowUnitOfLength PER_CENT = new WDWindowUnitOfLength("%");
  public static final WDWindowUnitOfLength PX = new WDWindowUnitOfLength("px");
   
  private final String value;
   
  private WDWindowUnitOfLength(String value){    
    this.value = value;
  }

  public String toString() {
    return value;
  }
}
