/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/WDWindowPos.java#1 $
 */package com.sap.tc.webdynpro.services.session.api;


/**
 * WDWindowPosEnum
 * @author SAP
 * @SAPWebDynproPart 2
 *
 * this class defines constants for the relativ position of an window instance.
 * @see com.sap.tc.webdynpro.services.session.api.IWDWindow setWindowPosition(WDWindowPos) for details
 */
public class WDWindowPos {
  public static final WDWindowPos LEFT = new WDWindowPos("WINDOW_LEFT");
  public static final WDWindowPos RIGHT = new WDWindowPos("WINDOW_RIGHT");
  public static final WDWindowPos TOP = new WDWindowPos("WINDOW_TOP");
  public static final WDWindowPos BOTTOM = new WDWindowPos("WINDOW_BOTTOM");
  public static final WDWindowPos CENTER = new WDWindowPos("WINDOW_CENTER");
   
  private final String value;
   
  private WDWindowPos(String value){    
    this.value = value;
  }

  public String toString() {
    return value;
  }
}
