/** 
 * Title:        Web Dynpro Java Runtime: 
 * Description:  
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/WDWindowFeature.java#1 $ 
 **/
package com.sap.tc.webdynpro.services.session.api;

import java.util.HashSet;
import java.util.Set;

/**
 * @author SAP
 * @SAPWebDynproPart 2
 *
 * This class represents an enumeration of window features.
 */
public class WDWindowFeature {
  private static final byte EXTERNAL_ONLY = 0;
  private static final byte INTERNAL_ONLY = 1;
  private static final byte EXTERNAL_INTERNAL = 2;
  
  public static Set EXTERNAL_FEATURES = new HashSet();
  public static Set INTERNAL_FEATURES = new HashSet();
  public static WDWindowFeature MENU_BAR = new WDWindowFeature("menubar", EXTERNAL_ONLY);
  public static WDWindowFeature TOOL_BAR = new WDWindowFeature("toolbar", EXTERNAL_ONLY);
  public static WDWindowFeature STATUS_BAR = new WDWindowFeature("statusbar", EXTERNAL_ONLY);
  public static WDWindowFeature ADDRESS_BAR = new WDWindowFeature("addressbar", EXTERNAL_ONLY);
  
  private final String feature;
  
  private WDWindowFeature(String featureName, byte availability){
    this.feature = featureName;
    switch(availability){
      case EXTERNAL_ONLY:
        EXTERNAL_FEATURES.add(this);
        break;
      case INTERNAL_ONLY:
        INTERNAL_FEATURES.add(this);
        break;
      default:
        EXTERNAL_FEATURES.add(this);
        INTERNAL_FEATURES.add(this);
    }
  }
  
  public String getFeatureName(){
    return this.feature;
  }
  
  /**
   * @see java.lang.Object#equals(java.lang.Object)
   */
  public boolean equals(Object arg0) {
    if((arg0.getClass() == WDWindowFeature.class) 
        && (this.feature.equals(((WDWindowFeature)arg0).feature))) 
      return true;
    return false;
  }
  /**
   * @see java.lang.Object#hashCode()
   */
  public int hashCode() {
    return this.feature.hashCode();
  }
  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return "WDWindowFeature: " + this.feature;
  }
}
