/*
 * SAP Copyright (c) 2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/WDCssSize.java#2 $
 */
package com.sap.tc.webdynpro.services.session.api;


/**
 * WDCssSize
 * @author SAP
 * @SAPWebDynproPart 2
 *
 * this class is used for the positions/unit of length of an window instance.
 */
public final class WDCssSize {
  /** initial value */
  public static final WDCssSize UNDEFINED = new WDCssSize(Integer.MAX_VALUE, WDWindowUnitOfLength.PX);
  /**  0px value */
  public static final WDCssSize ZERO_PX = new WDCssSize(0, WDWindowUnitOfLength.PX);
  /** value of an absolute position */   
  private final int value;
  /** unit of length of an absolute position */
  private final WDWindowUnitOfLength unitOfLength;
   
  /**
   * Constructor WDCssSize
   * @param value
   * @param unitOfLength
   */
  public WDCssSize(int value, WDWindowUnitOfLength unitOfLength){    
    this.value = value;
    if(unitOfLength == null) throw new IllegalArgumentException("unitOfLength must not be null!");
    this.unitOfLength = unitOfLength;
  }

  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {
    return String.valueOf(value) + unitOfLength.toString();
  }
  
}
