/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/IWDWindowManager.java#3 $
 */
package com.sap.tc.webdynpro.services.session.api;

import com.sap.tc.webdynpro.progmodel.repository.IWDEventHandlerInfo;
import com.sap.tc.webdynpro.progmodel.repository.IWDWindowInfo;

/**
 * Window Factory
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDWindowManager {
  /**
   * Method createConfirmationWindow
   * @param confirmationText
   * @param eventHandler
   * @param label
   * @return
   */
  public IWDConfirmationDialog createConfirmationWindow(String confirmationText, IWDEventHandlerInfo eventHandler, String label);
  
  /**
   * Method createWindow creates a window that contains/displays a Web Dynpro Components 
   * window with its view hiearchie. The window type is "external". External means a new 
   * browser window besides the current one.
   *  
   * In 6.30+, this window must be amodal, so use method createNonModalExternalWindow
   * @param URL
   * @param title
   * @param modal - has to be false
   * @return externa window instance 
   */
  public IWDWindow createExternalWindow(String URL, String title, boolean modal);

  /**
   * Method createNonModalExternalWindow creates a window that contains/displays 
   * the content of an url. The window type is "external". 
   * External means a new window besides the current one is opened.
   *  
   * @param URL
   * @param title
   * @return externa window instance   
   */
  public IWDWindow createNonModalExternalWindow(String URL, String title);
  
  /**
   * Method createWindow creates a window that contains/displays a Web Dynpro Components 
   * window with its view hiearchie. The window type is "internal". Internal 
   * means some clients that will be able to display it above the current view assembly and 
   * others will replace the view assemply. Each createWindow corresponds to a destroy on the
   * created window instance: a creation of a new instance of a windowInfo is only possible, if
   * it doesn't exist any other window instance with the same windowInfo (including interface views, 
   * which are embedded in other component instances). 
   * 
   * In 6.30+, this window must be internal and modal  
   *   
   * @param windowInfo   
   * @param modal has to be true
   * @return instance of internal window
   */
  public IWDWindow createWindow(IWDWindowInfo windowInfo, boolean modal);
  
  /**
   * Method createModalWindow creates a window that contains/displays a Web Dynpro Components 
   * window with its view hiearchie. The window type is "internal". Internal 
   * means some clients that will be able to display it above the current view assembly and 
   * others will replace the view assemply. Each createWindow corresponds to a destroy on the
   * created window instance: a creation of a new instance of a windowInfo is only possible, if
   * it doesn't exist any other window instance with the same windowInfo (including interface views, 
   * which are embedded in other component instances). 
   *   
   * @param windowInfo   
   * @return instance of internal modal window
   */
  public IWDWindow createModalWindow(IWDWindowInfo windowInfo);
}
