/*
 * SAP Copyright (c) 2003
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/session/api/IWDConfirmationDialog.java#1 $
 */
package com.sap.tc.webdynpro.services.session.api;

import com.sap.tc.webdynpro.progmodel.repository.IWDEventHandlerInfo;

/**
 * Application API for windows of the type ConfirmationDialog
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDConfirmationDialog extends IWDWindow{

  /**
   * Method addChoice - adds a choice (represented by a actionbutton) to the confimation dialog. Each choice references an eventhandler, which is called, if the button is pressed.
   * @param eventHandler - is called, if the button-representation is pressed
   * @param label - the label of the button representation
   */
  public void addChoice(IWDEventHandlerInfo eventHandler, String label);

  /**
   * Method addChoice - adds a choice (represented by a actionbutton) to the confimation dialog. Each choice references an eventhandler, which is called, if the button is pressed.
   * @param eventHandler - is called, if the button-representation is pressed
   * @param label - the label of the button representation
   * @param enabled - the flag, if the button representation is enabled
   */
  public void addChoice(IWDEventHandlerInfo eventHandler, String label, boolean enabled);
  
  /**
   * Method setIcon - this method sets an icon to the confirmation dialog. Only absolute urls are expected @see com.sap.tc.webdynpro.services.sal.url.api.IWDURLGenerator for details. 
   * @param icon - the absolute url for the icon
   */
  public void setIcon(String icon);

}
