/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/url/api/WDURLException.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.url.api;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * This exception is thrown, if an URL couldn't be generated by 
 * the URL generation service. The reasons might be, for instance, 
 * that an URL containing an alias couldn't be resolved correctly, 
 * etc. 
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDURLException extends WDException {
  
  /**
   * Constructs a <code>WDURLException</code> object.
   *
   * @param messageText message text of the exception
   */
  public WDURLException(String messageText) {
    super(messageText);
  }

  /**
   * Constructs a <code>WDURLException</code> object.
   *
   * @param messageText message text of the exception
   * @param reason the reason of the exception
   */
  public WDURLException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDURLException.
   * @param messageText
   * @param parameters
   */
  public WDURLException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDURLException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDURLException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

  /**
   * Constructs a <code>WDURLException</code> object.
   *
   * @param reason the reason of the exception
   */
  public WDURLException(Throwable reason) {
    super(reason);
  } 
  
  

}
