/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/url/api/IWDWebResource.java#2 $
 */
package com.sap.tc.webdynpro.services.sal.url.api;

import java.util.Map;

import com.sap.tc.webdynpro.services.sal.api.IWDService;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;

/**
 * The interface <code>IWDWebResource</code> represents a web resource
 * used by a Web Dynpro application. A web resource belongs to a specified
 * deployable object and application, has a certain name and MIME type. Besides
 * that, it is possible to associate name/value pairs to the web resource and
 * to generate the String that points to the web resource. The generated String then
 * contains the specified name/value pairs as String query parameters.
 *
 * @see com.sap.tc.webdynpro.services.sal.url.api.WDWebResource
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDWebResource extends IWDService {

  /**
   * Return is the URL that points to the web resource
   * specified by this <code>IWebResource</code> object.
   *
   * @return the URL to the specified web resource
   * @exception WDStringException if the String generation failed
   */
  public String getURL() throws WDURLException;

  /**
   * Return is the absoluteURL (containing protocol specification) 
   * that points to the web resource specified by this <code>IWebResource</code> 
   * object.
   *
   * @return the URL to the specified web resource
   * @exception WDStringException if the String generation failed
   */
  public String getAbsoluteURL() throws WDURLException;

  /**
   * Return is the name of the deployable object to which the
   * web resource belongs.
   *
   * @return the name of the deployable object to which the web resource
   * belongs
   */
  public String getObjectName();

  /**
   * Return is the deployable object part to which the
   * web resource belongs.
   *
   * @return the deployable object part where the web resource is used
   */
  public WDDeployableObjectPart getDeployableObjectPart();

  /**
   * Return is the resource type as defined by <code>WDWebResourceType</code>.
     *
   * @return the resource type of the web resource
   */
  public WDWebResourceType getResourceType();

  /**
   * Return is the resource name of the web resource.
     *
   * @return the resource name
   */
  public String getResourceName();

  /**
   * Adds a parameter to this web resource. When calling the method
   * <code>getString()</code>, the created String for this web resource
   * contains the added parameters as query part of the String.
   *
   * @param name the name of the parameter
   * @param value the value of the parameter
   */
  public void addParameter(String name, String value);

  /**
   * Removes an already added parameter.
   *
   * @param name the name of the parameter
   */
  public void removeParameter(String name);

  /**
   * Adds the parameters supplied as input parameter to this web resource.
   * When calling the method <code>getString()</code>, the created String for
   * this web resource contains the added parameters as query part of the
   * String. If one of the keys contained in <code>params</code> already
   * exists, the new parameter overwrites the old one.
   *
   * @param params the parameters added to this web resource
   */
  public void addParameters( Map params );

}
