/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/url/api/IWDURLGenerator.java#2 $
 */

package com.sap.tc.webdynpro.services.sal.url.api;

import java.util.Map;

import com.sap.tc.webdynpro.services.sal.api.IWDService;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDAliasResolvingException;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObjectPart;

/**
 * <code>IWDURLGenerator</code> defines the Web Dynpro URL generation service. This
 * service should be used to generated URLs for any <code>IWDWebResource</code> objects
 * that are referenced by Web Dynpro applications. 
 * <br>
 * The interface provides methods which are responsible for the following:
 * <ul>
 * <li> Get the real public resource path, independent of a deployable object and deployable object part
 * <li> Get the real public resource path on the level of a deployable object
 * <li> Get the real public resource path on the level of a deployable object part
 * <li> Get the URL of a specified web resource that is defined on the level of a deployable object
 * <li> Get the URL of a specified web resource that is defined on the level of a deployable object part
 * </ul>
 *
 * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDURLGenerator extends IWDService {   
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getPublicResourcePath(String)
   */  
  public String getPublicResourcePath(String resourceName); 
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getPublicResourcePath(WDDeployableObjectPart, String)
   */  
  public String getPublicResourcePath(WDDeployableObjectPart part, String resourceName);
      
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getResourcePath()
   */
  public String getResourcePath();

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getResourcePath(String)
   */
  public String getResourcePath(String objectName); 
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getResourcePath(String, String)
   */
  public String getResourcePath(String objectName, String resourceName);

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getResourcePath(WDDeployableObjectPart)
   */
  public String getResourcePath(WDDeployableObjectPart deployableObjectPart);

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getResourcePath(WDDeployableObjectPart, String) 
   */
  public String getResourcePath(WDDeployableObjectPart deployableObjectPart, String resourceName)
    throws WDAliasResolvingException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourcePath()
   */
  public String getWebResourcePath();

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourcePath(String)
   */
  public String getWebResourcePath(String objectName);

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourcePath(WDDeployableObjectPart)
   */
  public String getWebResourcePath(WDDeployableObjectPart deployableObjectPart);

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourceURL(String, String)
   */
  public String getWebResourceURL(String objectName, String resourceName) throws WDURLException;
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourceURL(String)
   */
  public String getWebResourceURL(String objectName) throws WDURLException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourceURL(WDDeployableObjectPart, String)
   */
  public String getWebResourceURL(WDDeployableObjectPart deployableObjectPart, String resourceName)
    throws WDURLException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWebResourceURL(WDDeployableObjectPart)
   */
  public String getWebResourceURL(WDDeployableObjectPart deployableObjectPart)
    throws WDURLException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getAbsoluteWebResourceURL(String, String)
   */
  public String getAbsoluteWebResourceURL(String objectName, String resourceName) throws WDURLException;
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getAbsoluteWebResourceURL(String)
   */
  public String getAbsoluteWebResourceURL(String objectName) throws WDURLException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getAbsoluteWebResourceURL(WDDeployableObjectPart, String)
   */
  public String getAbsoluteWebResourceURL(WDDeployableObjectPart deployableObjectPart, String resourceName)
    throws WDURLException;
    
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getAbsoluteWebResourceURL(WDDeployableObjectPart)
   */
  public String getAbsoluteWebResourceURL(WDDeployableObjectPart deployableObjectPart)
    throws WDURLException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getApplicationURL(WDDeployableObjectPart)
   */
  public String getApplicationURL(WDDeployableObjectPart deployableObjectPart) throws WDURLException;

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getApplicationURL(String, String)
   */
  public String getApplicationURL(String deployableObjectName, String applicationPartName) throws WDURLException;
  
  public String getDynamicApplicationURL(String deployableObjectName, String applicationPartName) throws WDURLException; 
  
  public String getDynamicApplicationURL(WDDeployableObjectPart deployableObjectPart) throws WDURLException;
  
  public String getStaticApplicationURL();
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWorkloadBalancedApplicationURL(String, String)
   */  
  public String getWorkloadBalancedApplicationURL(String deployableObjectName, String applicationPartName) throws WDURLException;  

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWorkloadBalancedApplicationURL(WDDeployableObjectPart)
   */  
  public String getWorkloadBalancedApplicationURL(WDDeployableObjectPart deployableObjectPart) throws WDURLException;  
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getApplicationURL(WDDeployableObjectPart, java.util.Map)
   */   
  public String getApplicationURL(WDDeployableObjectPart deployableObjectPart, Map urlParameters) throws WDURLException;  
    
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getApplicationURL(String, String, java.util.Map)
   */   
  public String getApplicationURL(String objectName, String partName, Map urlParameters) throws WDURLException;   
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWorkloadBalancedApplicationURL(WDDeployableObjectPart, java.util.Map)
   */   
  public String getWorkloadBalancedApplicationURL(WDDeployableObjectPart deployableObjectPart, Map urlParameters) throws WDURLException;   
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getWorkloadBalancedApplicationURL(String, String, java.util.Map)
   */   
  public String getWorkloadBalancedApplicationURL(String objectName, String partName, Map urlParameters) throws WDURLException; 
    
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getSAPIconsResourcePath()
   */   
  public String getSAPIconsResourcePath(); 

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getSAPIconsWebResourcePath()
   */ 
  public String getSAPIconsWebResourcePath();  
  
  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getPortalIconsResourcePath()
   */   
  public String getPortalIconsResourcePath(); 

  /**
   * @see com.sap.tc.webdynpro.services.sal.url.api.WDURLGenerator#getPortalIconsWebResourcePath()
   */ 
  public String getPortalIconsWebResourcePath();  
}
