/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/sl/api/WDUserDefinitionType.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.sl.api;

import com.sap.tc.webdynpro.services.exceptions.WDIllegalArgumentException;

/**
 * Class describing the different user definition types used to define a JCO client connection.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * 
 */
public final class WDUserDefinitionType { 
  
  private static final String DEFINED_USER_STRING = "useDefinedUser";
  private static final String SSO_USER_STRING =	 "useSSO";
  private static final String X509_USER_STRING = "useX509";
	private static final String MAPPED_USER_STRING = "useMappedUser";
      
  public static final WDUserDefinitionType DEFINED_USER = new WDUserDefinitionType (DEFINED_USER_STRING);
  public static final WDUserDefinitionType SSO_USER = new WDUserDefinitionType (SSO_USER_STRING);
  public static final WDUserDefinitionType X509_USER = new WDUserDefinitionType (X509_USER_STRING);
	public static final WDUserDefinitionType MAPPED_USER = new WDUserDefinitionType (MAPPED_USER_STRING);
  
  private String value = null;

  /**
   * Constructor for WDUserDefinitionType.
   */
  private WDUserDefinitionType(String value) {
    this.value = value;
  }

  public String toString () {
    return value;  
  }
  
  public static WDUserDefinitionType getType (String value) {
  
    if (value.equals(DEFINED_USER_STRING)) {
      return DEFINED_USER;  
    }
    else if (value.equals(SSO_USER_STRING)) {
      return SSO_USER;  
    }
    else if (value.equals(X509_USER_STRING)) {
      return X509_USER;  
    }
		else if (value.equals(MAPPED_USER_STRING)) {
			return MAPPED_USER;  
		}
    else {
      throw new WDIllegalArgumentException ("Invalid value string '" + value + "' to get user definition type");   
    }  
  }
}
