/*
 * SAP Copyright (c) 2003
 * All rights reserved
 * 
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/repository/api/WDRepository.java#2 $
 */

package com.sap.tc.webdynpro.services.sal.repository.api;

import com.sap.tc.webdynpro.services.sal.core.AbstractManager;
import com.sap.tc.webdynpro.services.sal.deployment.api.WDDeployableObject;

/**
 * The class provides access to <code>IWDRepositoryFactory</code> instances, which are the 
 * factories for runtime repository instances.  
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public abstract class WDRepository  {
      
  /**
   * Returns the factory for <code>IWDRepository</code> instances.
   *  
   * @return the factory for <code>IWDRepository</code> instances
   */
  public static IWDRepositoryFactory getRepositoryFactory() {
    return AbstractManager.getServerPlatformImplementation().getNewRepositoryFactory();     
  }
  
  /**
   * Return is the factory for <code>IWDRepository</code> instances.
   * The objects of the repository are expected to be part of the development
   * component specified by <code>developmentComponentName</code>. 
   * 
   * @param developmentComponentName the name of the development component
   * @return the factory for <code>IWDRepository</code> instances
   */
  public static IWDRepositoryFactory getRepositoryFactory(String developmentComponentName) {
    return AbstractManager.getServerPlatformImplementation().getNewRepositoryFactory(WDDeployableObject.getDeployableObject(developmentComponentName));     
  }    
}
