/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/deployment/api/WDClassLoaderException.java#2 $
 */
package com.sap.tc.webdynpro.services.sal.deployment.api;

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;

/**
 * Runtime exception thrown if the classloader of a deployed Web
 * Dynpro application couldn't be accessed.
 *
 * @deprecated This class might be withdrawn from the Web Dynpro API 
 *    with the first new NetWeaver release in 2006. It is not reasonable 
 *    for applications to explicitly catch this subclass of WDRuntimeException.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDClassLoaderException extends WDRuntimeException
{
  /**
   * Creates a WDClassLoaderException exception.
   */
  public WDClassLoaderException(String messageText) {
    super(messageText);
  }

  /**
   * Creates a WDClassLoaderException exception.
   */
  public WDClassLoaderException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Creates a WDClassLoaderException exception.
   */
  public WDClassLoaderException(Throwable reason) {
    super(reason);
  }

  /**
   * Creates a WDClassLoaderException exception.
   */
  public WDClassLoaderException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Creates a WDClassLoaderException exception.
   */
  public WDClassLoaderException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }
}
