/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/datatransport/api/IWDInputMassDatasource.java#1 $
 */
package com.sap.tc.webdynpro.services.sal.datatransport.api;

/**
  * This interface provides api for mass data input sources
  *  
  * @author SAP
  * @SAPWebDynproPart 2
  **/
public interface IWDInputMassDatasource {

  /**
   * defines that the element is send back to the client as attachment and not inplace, so that the attachement is opened by
   * a specific client program, which is specified by the content-type of the attachement
   * @param isAttachment - true means that it is handled as attachement
   */
  public void setAttachement(boolean isAttachment);
  
  /**
   * method setMakeCopy - sets a flag that the inputstream of this CachedWebResource is always copied before it is added to the cache.
   * It is important for inputstreams like httpinputstream, which have only a shortterm endurance.
   * @param makeCopy
   */
  public void setMakeCopy(boolean makeCopy);

  /**
   * Method setResourceName - sets the name of the resource/file, expects filename + suffix
   * @param resourceName
   */
  public void setResourceName(String resourceName);

}
