/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/config/api/WDConfigurationConstants.java#4 $
 */
package com.sap.tc.webdynpro.services.sal.config.api;

/**
 * This class defines constants used by the configuration service.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public final class WDConfigurationConstants {

  private WDConfigurationConstants() {
    // do nothing 
  }
 
  /** suffix of the config file */
  public static final String CONFIG_FILE_SUFFIX = ".properties";

	public static final String DEFAULT_CONFIG_FILE_PREFIX = "default";

  ///////////////////////////////////////////////////
  //
  // name of the property files
  //
  ///////////////////////////////////////////////////

  /** property file name (without file suffix) in which aliases are defined */
  public static final String ALIAS_PROPERTIES = "alias"; 
  
  /** property file name (without file suffix) in which available clients are defined */
  public static final String CLIENTS_PROPERTIES = "clients"; 

  /** property file name (without file suffix) in which JavsScript includes are defined */  
  public static final String INCLUDES_PROPERTIES = "includes"; 
  
  /** property file name (without file suffix) in which logging properties are defined */
  public static final String LOGGING_PROPERTIES = "logging"; 
  
  /** property file name (without file suffix) in which references to other deployable objects are defined */
  public static final String REFERENCES_PROPERTIES = "references"; 

  /** the name of the configuration unit where the aliases information is contained */
  public static final String ALIAS_CONFIG_FILE_NAME = ALIAS_PROPERTIES;

  /** the name of the configuration unit where the JavaScript include information is contained */
  public static final String INCLUDES_CONFIG_FILE_NAME = INCLUDES_PROPERTIES;
  
  /** the name of the configuration unit where the logging configuration is contained */
  public static final String LOGGING_CONFIG_FILE_NAME = LOGGING_PROPERTIES;

  /** the name of the configuration unit where the stylesheets information is contained. */
  public static final String STYLESHEETS_CONFIG_FILE_NAME = "stylesheets";

  //////////////////////////////////////////////////////////////
  //
  // names of properties used within the alias.properties file
  //
  //////////////////////////////////////////////////////////////

  /** the name of the property defining the deployable object name of an alias. */
  public static final String ALIAS_PROPERTY_OBJECT_NAME = ".Object";
  
  /** the name of the property defining the deployable object part name of an alias. */
  public static final String ALIAS_PROPERTY_OBJECT_PART_NAME = ".ObjectPartName";
  
  /** the name of the property defining the deployable object part type of an alias. */
  public static final String ALIAS_PROPERTY_OBJECT_PART_TYPE = ".ObjectPartType";
  
  //////////////////////////////////////////////////////////////
  //
  // names of properties used within the logging.properties file
  //
  //////////////////////////////////////////////////////////////
  
  /** name of the logging property that specifies the name of log file */
  public static final String LOGGING_PROPERTY_LOGFILE = "log[File].pattern";
  
  /** name of the logging property that specifies the log file count */
  public static final String LOGGING_PROPERTY_LOG_FILE_CNT = "log[File].cnt"; 
   
  /** name of the logging property that specifies the log file limit */
  public static final String LOGGING_PROPERTY_LOG_FILE_LIMIT = "log[File].limit"; 
  
  /** name of the logging property that specifies the log file limit */
  public static final String LOGGING_PROPERTY_LOG_FILE_FORMATTER = "formatter[FileFormat]";
  
  ////////////////////////////////////////////////////////////////////////
  //
  // names of properties used within the WebDynpro default.properties file
  //
  ////////////////////////////////////////////////////////////////////////

  /** 
   * the size of the log transported to the client in error case 
   * @deprecated This parameter is no longer supported, it may be withdrawn 
   *   with the first new NetWeaver release in 2006.
   */
  public static final String GLOBAL_PROPERTY_LOG_SIZE = "LogSize";

  /** 
   * the default value of the log size 
   * @deprecated This parameter is no longer supported, it may be withdrawn 
   *   with the first new NetWeaver release in 2006.
   */
  public static final int GLOBAL_PROPERTY_DEFAULT_LOG_SIZE_VALUE = 100;

  /** 
   * the polling interval of the watchdog
   * @deprecated This parameter is no longer supported, it may be withdrawn 
   *   with the first new NetWeaver release in 2006.
   */
  public static final String GLOBAL_PROPERTY_POLLING_INTERVAL = "PollingInterval";

  /** the default taken for APPLICATION_EXPIRATION_TIME in case it is not specified explicitly */
  public static final String GLOBAL_PROPERTY_DEFAULT_EXPIRATION_TIME = "DefaultExpirationTime";
  
  /** the default taken for GLOBAL_PROPERTY_DEFAULT_SERVER_SESSION_AT_LEAST_ONE_APP_SCOPE_EXPIRATION_TIME  */
  public static final String GLOBAL_PROPERTY_DEFAULT_SERVER_SESSION_AT_LEAST_ONE_APP_SCOPE_EXPIRATION_TIME = "DefaultServerSessionAtLeastOneAppScopeExpirationTime";
  
  /** specifies if the response strea, should be zipped or not */
  public static final String GLOBAL_PROPERTY_ZIP_RESPONSE = "ZipResponse";
    
  /** specifies if the runtime runs in development mode */
  public static final String GLOBAL_PROPERTY_DEVELOPMENT_MODE = "DevelopmentMode";
  
  /** specifies if some special URL parameters should be deactivated */
  public static final String GLOBAL_PROPERTY_ACTIVATE_URL_PARAMS = "ActivateURLParameters"; 
  
  /** 
   * specifies the URL to the session expired page
   * @deprecated This parameter is no longer supported, it may be withdrawn 
   *   with the first new NetWeaver release in 2006.
   */
  public static final String GLOBAL_PROPERTY_SESSION_EXPIRATION_URL = "sap.sessionExpiredURL";   
  
  /** specifies the URL to the invalid deployment state page */
  public static final String GLOBAL_PROPERTY_INVALID_DEPL_STATE_URL = "sap.invalidDeploymentStateURL"; 
  
  /** specifies the default system locale */
  public static final String GLOBAL_PROPERTY_DEFAULT_LOCALE = "sap.systemLocale"; 
  
  public static final String GLOBAL_PROPERTY_MAX_LIMIMT_VSET_IMMEDIATE = "sap.valuesetlimit.maximmediate";
  public static final String GLOBAL_PROPERTY_MAX_LIMIMT_VSET_ONDEMANDE = "sap.valuesetlimit.maxondemand";
  
  /** expiration time used for SLD cache */
  public static final String GLOBAL_PROPERTY_SLD_CACHE_EXP_TIME = "sap.sld.cacheExpirationTime"; 
  
  /** web dispatcher protocol */
  public static final String GLOBAL_PROPERTY_WEB_DISPATCHER_PROTOCOL = "sap.webdispatcher.protocol";
  
  /** web dispatcher host */  
  public static final String GLOBAL_PROPERTY_WEB_DISPATCHER_HOST = "sap.webdispatcher.host";
  
  /** web dispatcher port */  
  public static final String GLOBAL_PROPERTY_WEB_DISPATCHER_PORT = "sap.webdispatcher.port";
   
  /** 
   * resource cache deletion time 
   * defines the time span, after which a resource is removed of the ram/filesystem (if it is already made persistent)  
   */  
  public static final String GLOBAL_PROPERTY_RESOURCECACHE_DELETION_TIME = "sap.resourceCache.deletionTime";
  
  /** 
   * resource cache persistence time
   * defines the time span, after which a resource is made persistent  
   */  
  public static final String GLOBAL_PROPERTY_RESOURCECACHE_PERSISTENCE_TIME = "sap.resourceCache.persistenceTime";

  /** resource cache polling time */  
  public static final String GLOBAL_PROPERTY_RESOURCECACHE_POLLING_TIME = "sap.resourceCache.pollingTime";

  /** resource pool persistence directory */  
  public static final String GLOBAL_PROPERTY_RESOURCEPOOL_DIRECTORY = "sap.resourcePool.directory";
  
  public static final String GLOBAL_PROPERTY_WD_CSS = "sap.useWebDynproStyleSheet"; 
  
  ////////////////////////////////////////////////////////////////////
  //
  // names of properties used within the <application>.properties file
  //
  ////////////////////////////////////////////////////////////////////
  
  /** the time in seconds when an application expires due to missing user interaction */
  public static final String APPLICATION_PROPERTY_EXPIRATION_TIME = "sap.expirationTime";
  
  /**
   * Configuration parameter that defines if a customized logon form is used. 
   * Possible values of the parameter are relative URLs pointing to the HTML page that 
   * is used as logon form. 
   */
  public static final String APPLICATION_PROPERTY_LOGON_FORM = "LogonForm";     

  /** the URL that points to the logoff page */
  public static final String APPLICATION_PROPERTY_LOGOFF_URL = "sap.logoffURL";
  
  /** the URL that points to the page, which should be displayed, if no client is available */
  public static final String APPLICATION_PROPERTY_NOCLIENT_URL = "sap.noClientURL";

  /** configuration parameter that defines if authentication is required or not */
  public static final String APPLICATION_PROPERTY_AUTHENTICATION = "sap.authentication";
  
  /** configuration parameter that defines if the default locale of an application */
  public static final String APPLICATION_DEFAULT_LOCALE = "sap.locale"; 
  
  ////////////////////////////////////////////////////////////////////
  //
  // names of properties used within the directory.properties file
  //
  ////////////////////////////////////////////////////////////////////

  /** property specifying the logical name of an application as used in the URL */
  public static final String DIRECTORY_PROPERTY_APPLICATION_OFFSET = "application.";

  /** property specifying the name of the used components */
  public static final String DIRECTORY_PROPERTY_COMPONENT_OFFSET = "component";

  /** property specifying the name of the component configuration */
  public static final String DIRECTORY_PROPERTY_COMPONENT_CONFIGURATION_OFFSET = "componentConfiguration";

  /** property specifying the name of the component interface */
  public static final String DIRECTORY_PROPERTY_COMPONENT_INTERFACE_OFFSET = "componentInterface";
  
  
  ////////////////////////////////////////////////////////////////////
  //
  // names of properties used within the includes.properties file
  //
  ////////////////////////////////////////////////////////////////////
    
  /** property specifying the offset name of the includes which should be included for all clients */
  public static final String INCLUDES_PROPERTY_ALL_OFFSET = "all"; 
  
  /** property specifying the offset name of the includes which should be included for IE5 clients */
  public static final String INCLUDES_PROPERTY_IE5_OFFSET = "ie5"; 
    
  //////////////////////////////////////////////////////////////////
  //
  // names of properties used within the references.properties file
  //
  //////////////////////////////////////////////////////////////////

  public static final String REFERENCES_PROPERTY_REFERENCE_OFFSET = "reference"; 
  
  ////////////////////////////////////////////////////////////////////
  //
  // names of properties used within jco.properties file
  //
  ////////////////////////////////////////////////////////////////////
  
  public static final String JCO_CONFIGURATION_FILE = "jco.properties";
  
  public static final String JCO_CONFIGURATION_PARAMETER_MAX_POOL_SIZE = "maxPoolSize";
  public static final String JCO_CONFIGURATION_PARAMETER_DFLT_MAX_POOL_SIZE = "sap.defaultMaxPoolSize";
  
	public static final String JCO_CONFIGURATION_PARAMETER_MAX_NUMBER_OF_CONN = "maxNumberOfConnections";
	public static final String JCO_CONFIGURATION_PARAMETER_DFLT_MAX_NUMBER_OF_CONN = "sap.defaultMaxNumberOfConnections";
	
	public static final String JCO_CONFIGURATION_PARAMETER_MAX_WAIT_TIME = "maxWaitTime";
	public static final String JCO_CONFIGURATION_PARAMETER_DFLT_MAX_WAIT_TIME = "sap.defaultMaxWaitTime";
	
	public static final String JCO_CONFIGURATION_PARAMETER_CONNECTION_TIME_OUT = "connectionTimeOut";
	public static final String JCO_CONFIGURATION_PARAMETER_DFLT_CONNECTION_TIME_OUT = "sap.defaultConnectionTimeOut";
  
  public static final String JCO_CONFIGURATION_PARAMETER_MSG_SERVER = "msgServer";
  public static final String JCO_CONFIGURATION_PARAMETER_SYSTEM_NAME = "systemName";
  public static final String JCO_CONFIGURATION_PARAMETER_LOGON_GROUP = "logonGroup";
  
  public static final String JCO_CONFIGURATION_PARAMETER_APPLICATION_SERVER = "applicationServer";
  public static final String JCO_CONFIGURATION_PARAMETER_SYSTEM_NUMNER = "systemNumber";
  
  public static final String JCO_CONFIGURATION_PARAMETER_CLIENT = "client";
  
  public static final String JCO_CONFIGURATION_PARAMETER_USER_DEFINITION = "userDefinition";
  public static final String JCO_CONFIGURATION_PARAMETER_USER_DEFINITION_4_SSO = "useSSO";
  public static final String JCO_CONFIGURATION_PARAMETER_USER_DEFINITION_4_X509 = "useX509";
  public static final String JCO_CONFIGURATION_PARAMETER_USER_DEFINITION_4_SNC = "useSNC";
  public static final String JCO_CONFIGURATION_PARAMETER_USER_DEFINITION_4_DEF_USER = "useDefinedUser";
	public static final String JCO_CONFIGURATION_PARAMETER_USER_DEFINITION_4_MAPPED_USER = "useMappedUser";
  
  public static final String JCO_CONFIGURATION_PARAMETER_USER = "user";
  public static final String JCO_CONFIGURATION_PARAMETER_PASSWORD = "password";
  public static final String JCO_CONFIGURATION_PARAMETER_LANGUAGE = "language";  
  
  ////////////////////////////////////////////////////////////////////
  //
  // names of properties used within sld.properties file
  //
  ////////////////////////////////////////////////////////////////////  
  
  public static final String SLD_HOST_NAME = "hostName";
  public static final String SLD_PORT_NUMBER = "portNumber";
  public static final String SLD_USER = "user";
  public static final String SLD_PASSWORD = "password";

  public static final String SLD_J2EE_CLUSTER_NAME = "j2eeClusterName";  
  
	////////////////////////////////////////////////////////////////////
	//
	// names of properties used to define the text mappings mode
	//
	////////////////////////////////////////////////////////////////////  
  
	/** property specifying whether or not text mapping should be used */
	public static final String USE_TEXT_MAPPING = "sap.textMapping.enable";
	
	/** property specifying the name of the DC containing the defined text mappings */
	public static final String TEXT_MAPPING_DC_NAME = "sap.textMapping.objectName";
	
	/** property specifying the set of possible separators for word-based text mapping of messages */
	public static final String TEXT_MAPPING_SEPARATORS = "sap.textMapping.separators";
  
  /** property specifying the system name */
	public static final String TEXT_MAPPING_SYSTEM_NAME = "sap.textMapping.systemName";
	
	/** property specifying the system number */
	public static final String TEXT_MAPPING_SYSTEM_NUMBER = "sap.textMapping.systemNumber";  
  
  ///////////////////////////
  //
  // misc
  //
  ///////////////////////////
  
  public static final String RELOAD_PROPERTY = "configuration.reload";
  
	/** property specifying the patch to the used default theme */
  public static final String THEME_URL = "sap.theme.default";
  
}
