/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/api/WDServerPlatformException.java#2 $ 
 */
package com.sap.tc.webdynpro.services.sal.api;

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;


/**
 * Web Dynpro runtime exception thrown if the specified server platform implementation 
 * or one of the requested classes of the server platform implementation couldn't be 
 * found or loaded. 
 * 
 * @deprecated This class might be withdrawn from the Web Dynpro API 
 *    with the first new NetWeaver release in 2006. It is not reasonable 
 *    for applications to explicitly catch this subclass of WDRuntimeException.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDServerPlatformException extends WDRuntimeException
{
  /**
   * Creates a web dynpro server platform exception.
   */
  public WDServerPlatformException(String messageText) {
    super(messageText); 
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDServerPlatformException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDServerPlatformException(Throwable reason) {
    super(reason); 
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDServerPlatformException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDServerPlatformException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }
}
