/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/api/WDDispatcherException.java#2 $
 */
package com.sap.tc.webdynpro.services.sal.api;

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;


/**
 * Web Dynpro runtime exception thrown if the request dispatcher
 * (e.g. the dispatcher servlet, the Web Dynpro portal component, or
 * other Web Dynpro servlets) fail to dispatch the request to the
 * Web Dynpro runtime for some reason.
 *
 * @deprecated This class might be withdrawn from the Web Dynpro API 
 *    with the first new NetWeaver release in 2006. It is not reasonable 
 *    for applications to explicitly catch this subclass of WDRuntimeException.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDDispatcherException extends WDRuntimeException
{
  /**
   * Creates a web dynpro dispatcher exception.
   */
  public WDDispatcherException(String messageText) {
    super(messageText);
  }

  /**
   * Creates a web dynpro dispatcher exception.
   */
  public WDDispatcherException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Creates a web dynpro dispatcher exception.
   */
  public WDDispatcherException(Throwable reason) {
    super(reason);
  }

  /**
   * Creates a web dynpro dispatcher exception.
   */
  public WDDispatcherException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Creates a web dynpro dispatcher exception.
   */
  public WDDispatcherException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }
}
