/*
 * SAP Copyright (c) 2002
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/api/IWDService.java#1 $
 */

package com.sap.tc.webdynpro.services.sal.api;

/**
 * Common interface for all Web Dynpro server platform services.
 *
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDService {
  /**
   * Return is the name of the service.
   * 
   * @return name of the service
   */
  public String getServiceName();

  /**
   * Return is the description of the service.
   * 
   * @return description of the service
   */
  public String getDescription();

  /**
   * Return is the version of the service.
   * 
   * @return the version of the service
   */
  public String getVersion();
}
