/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/admin/api/WDProductInfo.java#4 $
 */
package com.sap.tc.webdynpro.services.sal.admin.api;

import com.sap.tc.webdynpro.services.sal.core.AbstractManager;

/**
 * <code>WDProductInfo</code> provides static methods to access product information.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public abstract class WDProductInfo {

  private static ProductInfoMBean mBean = AbstractManager.getServerPlatformImplementation().getProductInfo();
 
  public static final String UNDEFINED_MODE = "0";
  public static final String DEVELOPMENT_MODE = "1"; 
  public static final String TEST_MODE = "2";
  public static final String TRAINING_MODE = "3";  
  public static final String PRODUCTIVE_MODE = "4";
 
  /**
   * Return is the vendor name.
   * 
   * @return the vendor name   
   */
  public static String getVendorName() {
    return mBean.getVendorName();   
  }

  /**
   * Return is the build ID.
   * 
   * @return the build ID   
   */
  public static String getBuildID() {
    return mBean.getBuildID(); 
  }
  
  /**
   * Return is the associated MBean.
   *  
   * @return the associated MBean
   */
  public static ProductInfoMBean getMBean() {
    return mBean;   
  } 
  
  /**
   * Return is the string representation of the product information.
   * 
   * @return the string representation of the product information
   */
  public static String getStringRepresentation() {
    return mBean.getStringRepresentation();   
  }

  /**
   * Return is the product name.
   * 
   * @return the product name
   * @deprecated No longer written by build process, method returns emtpy string.
   *   This method may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static String getProductName() {
    return mBean.getProductName(); 
  }

  /**
   * Return is the product description.
   * 
   * @return the product description
   * @deprecated No longer written by build process, method returns emtpy string.
   *   This method may be withdrawn with the first new NetWeaver release in 2006.
   */  
  public static String getProductDescription() {
    return mBean.getProductDescription();   
  }

  /**
   * Return is the copyright.
   * 
   * @return the copyright
   * @deprecated no longer written by build process, method returns emtpy string.
   *   This method may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static String getCopyright() {    
    return mBean.getCopyright();   
  }
  
  /**
   * Return is the actual version.
   * 
   * @return the actual version
   * @deprecated no longer written by build process, method returns emtpy string.
   *   This method may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static String getVersion() {
    return mBean.getVersion();   
  }

  /**
   * Return is the service pack number.
   * 
   * @return the service pack number  
   * @deprecated no longer written by build process, method returns emtpy string.   
   *   This method may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static String getServicePackNumber() {
    return mBean.getServicePackNumber(); 
  }
  
  /**
   * Return is the build date.
   * 
   * @return the build date   
   * @deprecated no longer written by build process, method returns emtpy string.   
   *   This method may be withdrawn with the first new NetWeaver release in 2006.
   */
  public static String getBuildDate() {
    return mBean.getBuildDate();   
  }
  
  /**
   * Returns the system type of the J2EE server installation. If undefined, "0" is returned.
   * Otherwise the following values are returned:
   * <ul>
   * <li> undefined: "0"
   * <li> development system: "1";
   * <li> test system = "2";
   * <li> training system: "3";
   * <li> productive system = "4";
   * </ul>
   * You can use the constants defined in this class.  
   *    
   * @return the system type of the J2EE server installation
   * @see com.sap.engine.services.licensing.LicensingRuntimeInterface#getSystemType()   
   */  
  public static String getSystemType() {
    return mBean.getSystemType();
  }
  
  /**
   * Returns true if the J2EE server system runs in productive mode. 
   * @return true if the J2EE server system runs in productive mode
   */
  public static boolean isProductiveMode() {
    return mBean.isProductiveMode(); 
  }
  
  /**
   * Returns true if the J2EE server system runs in development mode. 
   * @return true if the J2EE server system runs in development mode
   */  
  public static boolean isDevelopmentMode() {
    return mBean.isDevelopmentMode();
  }
  
  /**
   * Returns true if the J2EE server system runs in test mode. 
   * @return true if the J2EE server system runs in test mode
   */  
  public static boolean isTestMode() {
    return mBean.isTestMode();
  }
  
  /**
   * Returns true if the J2EE server system runs in training mode. 
   * @return true if the J2EE server system runs in training mode
   */  
  public static boolean isTrainingMode() {
    return mBean.isTrainingMode();   
  }

  /**
   * Returns true if the J2EE server system runs in undefined mode. 
   * @return true if the J2EE server system runs in undefined mode
   */    
  public static boolean isUndefinedMode() {
    return mBean.isUndefinedMode();    
  }
}
