/** 
 * Title:        Web Dynpro Java Runtime: 
 * Description:  
 * Copyright:    Copyright (c) 2002
 * Company:      SAP AG
 * @author SAP
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/sal/adapter/api/IWDWebContextAdapter.java#3 $ 
 **/

package com.sap.tc.webdynpro.services.sal.adapter.api;

import java.util.Map;

import com.sap.tc.webdynpro.services.cal.api.WDResponseStatusCodeType;
import com.sap.tc.webdynpro.services.sal.api.IWDService;

/**
 * this interface defines an abstraction for the protocol used for clientserver communication.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public interface IWDWebContextAdapter extends IWDService{

  /**
   * Method encodeRedirectURL.
   * Encodes the specified URL by including the session ID (especially jsessionID)in it, or, 
   * if encoding is not needed, returns the URL unchanged. 
   * 
   * @param url The url to encode
   * @return String
   */
  public String encodeRedirectURL(String url);

  /**
   * Method getRequestParameter.
   * returns the parameter value for the specified key
   * @param key - key for the parameter value
   * @return String
   */
  public String getRequestParameter(String key);
  
  /**
   * Method getRequestParameterValues.
   * returns all parameter values for the specified key
   * @param key - key for the parameter value
   * @return String[]
   */
  public String[] getRequestParameterValues(String key);

  /**
   * Method getRequestParameterMap.
   * returns the parameter map for the request
   * @return Map - the complete map of parameter values
   * Do not write data to this map!
   */
  public Map getRequestParameterMap();
  
  /**
   * Method setResponseStatusCode allows to set the response code e.g. in case of 
   * a httpResponse to 500. 
   * This method should be called in case of exceptions being catched by the application 
   * itself that prevents it from accepting a further request.
   * @param statusCode
   */
   public void setResponseStatusCode(WDResponseStatusCodeType statusCode);
}
