/*
 * SAP Copyright (c) 2002-2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDNonFatalRuntimeException.java#2 $
 */
package com.sap.tc.webdynpro.services.exceptions;

/**
 * This exception can be thrown if the normal process of an application shall be
 * canceled, but the application shall continue. Exceptions of this class are
 * returned as errors to the user, whereas all other Exceptions (esp.
 * RuntimeExceptions) terminate the application. </p>
 *
 * Applications using Web Dynpro can reference or catch this exception,
 * but THEY MUST NOT THROW OR EXTEND IT! </p>
 *  
 * @SAPWebDynproPart 2
 */
public class WDNonFatalRuntimeException extends WDRuntimeException
{
  public WDNonFatalRuntimeException(String messageText) {
    super(messageText);
  }

  public WDNonFatalRuntimeException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  public WDNonFatalRuntimeException(Throwable reason) {
    super(reason);
  }

  public WDNonFatalRuntimeException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  public WDNonFatalRuntimeException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }
}
