/*
 * SAP Copyright (c) 2002-2004
 * All rights reserved
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/exceptions/WDIllegalArgumentException.java#2 $ 
 */
package com.sap.tc.webdynpro.services.exceptions; 

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;

/**
 * Web Dynpro runtime exception thrown if an illegal argument is passed to 
 * a method, i.e. one of the preconditions of a method is injured.  
 * 
 * Applications using Web Dynpro can reference or catch this exception,
 * but THEY MUST NOT THROW OR EXTEND IT! </p>
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 */
public class WDIllegalArgumentException extends WDRuntimeException
{
  /**
   * Creates a web dynpro server platform exception.
   */
  public WDIllegalArgumentException(String messageText) {
    super(messageText); 
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDIllegalArgumentException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDIllegalArgumentException(Throwable reason) {
    super(reason); 
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDIllegalArgumentException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Creates a web dynpro server platform exception.
   */
  public WDIllegalArgumentException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }
}
