/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/cal/core/exceptions/WDUserAbortException.java#2 $
 */
package com.sap.tc.webdynpro.services.cal.core.exceptions;

/**
 * Thrown if the execution of an <code>IClientTask</code> is aborted due to an user 
 * abort of the actual session. 
 * 
 * @deprecated This class is not part of the Web Dynpro API and might be withdrawn
 *    with the first new NetWeaver release in 2006. It is not reasonable for applications 
 *    to explicitly catch this subclass of WDException.
 * 
 * @author SAP
 * @SAPWebDynproPart 5
 */
public class WDUserAbortException extends WDClientTaskException {

  /**
   * Constructor for WDUserAbortException.
   * @param messageText
   */
  public WDUserAbortException(String messageText) {
    super(messageText);
  }

  /**
   * Constructor for WDUserAbortException.
   * @param messageText
   * @param reason
   */
  public WDUserAbortException (String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDUserAbortException.
   * @param reason
   */
  public WDUserAbortException(Throwable reason) {
    super(reason);
  }

  /**
   * Constructor for WDUserAbortException.
   * @param messageText
   * @param parameters
   */
  public WDUserAbortException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDUserAbortException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDUserAbortException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

}
