/*
 * SAP Copyright (c) 2002
 * All rights reserved.
 *
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/cal/core/exceptions/WDClientTaskException.java#2 $
 */
package com.sap.tc.webdynpro.services.cal.core.exceptions;

import com.sap.tc.webdynpro.services.exceptions.WDException;

/**
 * Base class of exceptions thrown if something goes wrong in the execution of 
 * an <code>IClientTask</code>. 
 * 
 * @deprecated This class is not part of the Web Dynpro API and might be withdrawn
 *    with the first new NetWeaver release in 2006. It is not reasonable for applications 
 *    to explicitly catch this subclass of WDException.
 * 
 * @author SAP
 * @SAPWebDynproPart 5
 */
public class WDClientTaskException extends WDException {

  /**
   * Constructor for WDClientTaskException.
   * @param messageText
   */
  public WDClientTaskException(String messageText) {
    super(messageText);
  }

  /**
   * Constructor for WDClientTaskException.
   * @param messageText
   * @param reason
   */
  public WDClientTaskException(String messageText, Throwable reason) {
    super(messageText, reason);
  }

  /**
   * Constructor for WDClientTaskException.
   * @param reason
   */
  public WDClientTaskException(Throwable reason) {
    super(reason);
  }

  /**
   * Constructor for WDClientTaskException.
   * @param messageText
   * @param parameters
   */
  public WDClientTaskException(String messageText, Object[] parameters) {
    super(messageText, parameters);
  }

  /**
   * Constructor for WDClientTaskException.
   * @param messageText
   * @param parameters
   * @param reason
   */
  public WDClientTaskException(String messageText, Object[] parameters, Throwable reason) {
    super(messageText, parameters, reason);
  }

}
