
package com.sap.tc.webdynpro.services.api;

import com.sap.dictionary.types.services.NamingService;

/**
 * API class containing several static utitily methods.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/api/WDUtil.java#1 $
 */
public abstract class WDUtil {

  /**
   * Private constructor to prevent instantiation.
   */
  private WDUtil() {
  }

  /**
   * Converts the name of an ABAP type to the naming conventions
   * within Java.
   * 
   * <b>Note:</b> This method actually is <b>not</b> a Web Dynpro service! But
   * the underlying packages are not stable yet. We provide this method here
   * to enable Web Dynpro users to perform such a conversion. Be prepared that
   * this method will be deprecated, once it becomes available in its real place.
   * 
   * @param name The type name in ABAP
   * @return The type name as used in Java
   */
  public static String getJavaNameForAbapTypeName(String name) {
    return NamingService.Type.getJavaNameFromBackendName(
        NamingService.Type.getBackendNameFromABAPName(name));
  }

  /**
   * Converts the name of an ABAP structure to the naming conventions
   * within Java.
   * 
   * <b>Note:</b> This method actually is <b>not</b> a Web Dynpro service! But
   * the underlying packages are not stable yet. We provide this method here
   * to enable Web Dynpro users to perform such a conversion. Be prepared that
   * this method will be deprecated, once it becomes available in its real place.
   * 
   * @param name The structure name in ABAP
   * @return The structure name as used in Java
   */
  public static String getJavaNameForAbapStructureName(String name) {
    return NamingService.Structure.getJavaNameFromBackendName(
        NamingService.Structure.getBackendNameFromABAPName(name));
  }

  /**
   * Converts the name of an ABAP structure field to the naming conventions
   * within Java.
   * 
   * <b>Note:</b> This method actually is <b>not</b> a Web Dynpro service! But
   * the underlying packages are not stable yet. We provide this method here
   * to enable Web Dynpro users to perform such a conversion. Be prepared that
   * this method will be deprecated, once it becomes available in its real place.
   * 
   * @param name The field name in ABAP
   * @return The field name as used in Java
   */
  public static String getJavaNameForAbapFieldName(String name) {
    return NamingService.Field.getJavaNameFromBackendName(
        NamingService.Field.getBackendNameFromABAPName(name));
  }
}
