package com.sap.tc.webdynpro.services.api;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

import com.sap.tc.webdynpro.services.exceptions.WDRuntimeException;

/**
 * This class is a factory for helper classes within the API.
 * 
 * Although being in the API, it is not primarily intended for application
 * programmers. It creates instances for API interfaces, where the implementation
 * is Web Dynpro internal.
 * 
 * @author SAP
 * @SAPWebDynproPart 2
 * @version $Id: //tc/WebDynproRuntime/630_VAL_REL/src/_webdynpro_services/java/com/sap/tc/webdynpro/services/api/WDHelperFactory.java#1 $
 */
public class WDHelperFactory {

  private static final String RESOURCE_NAME = 
      "com/sap/tc/webdynpro/services/api/WDHelperFactory.properties";

  private static final Properties properties = new Properties();
  static {
    InputStream inStream = WDHelperFactory.class.getClassLoader().getResourceAsStream(RESOURCE_NAME);
    if (inStream == null) {
      throw new WDRuntimeException("Could not find {0}", new Object[]{RESOURCE_NAME});
    } else {
      try{
        properties.load(inStream);
      }catch (IOException e){
        throw new WDRuntimeException(e);
      }
    }
  }

  private static Object createInstance(String className) {
    try {
      return Class.forName(className).newInstance();
    } catch (ClassNotFoundException e) {
      throw new WDHelperNotFoundException(e);
    } catch (InstantiationException e) {
      throw new WDHelperNotFoundException(e);
    } catch (IllegalAccessException e) {
      throw new WDHelperNotFoundException(e);
    }
  }

  public static Object getInstance(Class aClass) {
    String implementationName = properties.getProperty(aClass.getName());
    if (implementationName == null) {
      throw new WDHelperNotFoundException(aClass);
    }
    return createInstance(implementationName);
  }

  public static Object getInstance(Class aClass, String qualifier) {
    String implementationName = properties.getProperty(aClass.getName() + '/' + qualifier);
    if (implementationName == null) {
      throw new WDHelperNotFoundException(aClass);
    }
    return createInstance(implementationName);
  }
}
