#
# =====================================================
# @(#) XMLIMAPI                   7.4        2002-11-11
# =====================================================
# Changes in  7.4:
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def install (session,options):
    """Installing tables for WebDAV XML Indexing
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    requireSysdba (session)

    #----------------------------------------------------------------------------
    # Table XML_XMLINDEX
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_XMLINDEX"):
        stopIfSqlNotOK (session, """
			Create Table XML_XMLIndex
			(
				IDXID			Char(24)		Byte		,
				Name			SYSXML_CHAR_SHORT			,
				Description		SYSXML_CHAR_LONG			,
				XPATHbase		SYSXML_CHAR_LONG			,
				XPATHvalue		SYSXML_CHAR_LONG			,

				Primary Key (IDXID)							,
				Constraint XML_XMLIndex_1 Unique (Name)
			) INTERNAL""")

    #----------------------------------------------------------------------------
    # Table XML_DOCUMENTCLASS
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_DOCUMENTCLASS"):
        stopIfSqlNotOK (session, """
			create table XML_DOCUMENTCLASS
			(
				DCID			Char(24)		Byte		,
				Name			SYSXML_CHAR_SHORT			,
				Description		SYSXML_CHAR_LONG			,

				primary key (DCID,Name)						,
				Constraint XML_DocumentClass_1 Unique (Name)
			) INTERNAL""")

    #----------------------------------------------------------------------------
    # Table XML_ASSIGN_DC_IDX
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_ASSIGN_DC_IDX"):
        stopIfSqlNotOK (session, """
			create table XML_ASSIGN_DC_IDX
			(
				DCID			Char(24)		Byte		,
				IDXID			Char(24)		Byte		,

				primary key (DCID,IDXID)
			) INTERNAL""")

    #----------------------------------------------------------------------------
    # Table XML_SESSIONPOOL
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_SESSIONPOOL"):
        stopIfSqlNotOK (session, """
			Create Table XML_SESSIONPOOL (
				Id				Char(24)		Byte		,
				Name			SYSXML_CHAR_SHORT			,
				Description		SYSXML_CHAR_LONG			,
				DbNode			SYSXML_CHAR_SHORT			,
				DbName			SYSXML_CHAR_SHORT			,
				DbUser			SYSXML_CHAR_SHORT			,
				DbPassword		SYSXML_CHAR_SHORT			,
				TraceFile		SYSXML_CHAR_MIDDLE			,

				primary key (Id)							,
				Constraint XML_SessionPool_1 Unique (Name)
			) INTERNAL""")

        stopIfSqlNotOK (session, """
			insert into XML_SESSIONPOOL set
				Id = X'000000000000000000000000000000000000000000000000',
				Name = '',
				Description = '',
				DbNode = '',
				DbName = '',
				DbUser = '',
				DbPassword = '',
				TraceFile = ''
        """)

        stopIfSqlNotOK (session, """
			insert into XML_SESSIONPOOL set
				Id = X'000000000000000000000000000000000000000000000001',
				Name = 'WebDAV asynchron',
				Description = 'Connection for asynchronous XML Indexing for WebDAV',
				DbNode = 'your node',
				DbName = 'your DB',
				DbUser = 'your user',
				DbPassword = 'your password',
				TraceFile = ''
        """)

    #----------------------------------------------------------------------------
    # Table XML_INDEXINGSERVICEDESC
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_INDEXINGSERVICEDESC"):
        stopIfSqlNotOK (session, """
			Create Table XML_INDEXINGSERVICEDESC (
				Id					Char(24)		Byte		,
				Name				SYSXML_CHAR_SHORT			,
				Description			SYSXML_CHAR_LONG			,
				DocumentStore       Char(24)		Byte		,
				IndexStore          Char(24)		Byte		,
				isSynchronous		Char(1)			ASCII		,

				Primary Key (Id)							,
				Constraint XML_IndexingServiceDesc_1 Unique (Name),
				Foreign Key XML_Sessionpool_DocStore (DocumentStore) References XML_SESSIONPOOL,
				Foreign Key XML_Sessionpool_IdxStore (IndexStore) References XML_SESSIONPOOL
			) INTERNAL""")

        stopIfSqlNotOK (session, """
			insert into XML_INDEXINGSERVICEDESC set
				Id = X'000000000000000000000000000000000000000000000001',
				Name = 'WebDAV synchronous',
				Description = 'WebDAV XML Indexing Service (embedded)',
				DocumentStore = X'000000000000000000000000000000000000000000000000',
				IndexStore = X'000000000000000000000000000000000000000000000000',
				isSynchronous = '1'
        """)

        stopIfSqlNotOK (session, """
			insert into XML_INDEXINGSERVICEDESC set
				Id = X'000000000000000000000000000000000000000000000002',
				Name = 'WebDAV asynchronous',
				Description = 'WebDAV XML Indexing service via XML IndexEngine',
						DocumentStore = X'000000000000000000000000000000000000000000000001',
						IndexStore = X'000000000000000000000000000000000000000000000001',
				isSynchronous = '0'
        """)

    #----------------------------------------------------------------------------
    # Table XML_INDEXENGINE
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_INDEXENGINE"):
        stopIfSqlNotOK (session, """
			Create Table XML_INDEXENGINE (
				Id				Char(24)		Byte		,
				Name            SYSXML_CHAR_SHORT			,
				Description     SYSXML_CHAR_LONG			,
				Node			SYSXML_CHAR_MIDDLE			,
				InstRoot    	SYSXML_CHAR_LONG			,
				ISID            Char(24)		Byte		,
				ILIBID          Char(24)		Byte		,
				LogFile         SYSXML_CHAR_LONG			,
				Alive           Timestamp DEFAULT TIMESTAMP	,
				Refresh			Char(1)			ASCII		,

				Primary Key (Id)							,
				Constraint XML_IndexEngine_1 Unique (Name, Node)
			) INTERNAL""")

    #----------------------------------------------------------------------------
    # Table XML_INDEXINGLIB
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_INDEXINGLIB"):
        stopIfSqlNotOK (session, """
			Create Table XML_INDEXINGLIB (
				Id				Char(24)		Byte		,
				Name			SYSXML_CHAR_SHORT			,
				Description		SYSXML_CHAR_LONG			,
				Version			SYSXML_CHAR_SHORT			,

				Primary Key (Id)							,
				Constraint XML_IndexingLib_1 Unique (Name,Version)
			) INTERNAL""")

        stopIfSqlNotOK (session, """
			insert into XML_INDEXINGLIB set
				Id = X'000000000000000000000000000000000000000000000001',
				Name = 'WebDAV_ASYNC',
				Description = 'SericeLib WebDAV XML Indexing',
				Version = '1.0'
        """)

    #----------------------------------------------------------------------------
    # Table XML_SEARCHLIB
    #----------------------------------------------------------------------------

    if not existsTable (session, "XML_SEARCHLIB"):
        stopIfSqlNotOK (session, """
			Create Table XML_SEARCHLIB (
				Id				Char(24)		Byte		,
				Name			SYSXML_CHAR_SHORT			,
				Description		SYSXML_CHAR_LONG			,
				Version			SYSXML_CHAR_SHORT			,
				Changed			Char(1)						,
				Library         Long			Byte		,
				ILIBID          Char(24)		Byte		,

				Primary Key (Id)							,
				Constraint XML_IndexingLib_1 Unique (Name)
			) INTERNAL""")

        stopIfSqlNotOK (session, """
			insert into XML_SEARCHLIB set
				Id = X'000000000000000000000000000000000000000000000001',
				Name = 'WebDAV_ASYNC',
				Description = 'SearchLib WebDAV XML Indexing',
				Version = '1.0',
				Changed = '0',
				ILIBID = X'000000000000000000000000000000000000000000000001'
        """)

    #----------------------------------------------------------------------------
    # Commit the data definitions
    #----------------------------------------------------------------------------

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


