#
# =====================================================
# @(#) XDDCOM                    7.4        2003-03-28
# =====================================================
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def install (session,options):
    """Installing comments for DOMAIN tables
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')


    # Table domain.charsets

    #COMMENT ON TABLE DOMAIN.CHARSETS IS 'All CHARACTER SETs on the SERVERDB'

    #COMMENT ON COLUMN DOMAIN.CHARSETS.CODE IS 'CHARACTER SET name'

    # Table domain.columns

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.COLUMNS IS 'Columns of all tables, views, synonyms and results accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.OWNER IS 'Name of owner of database object'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.TABLENAME IS 'Name of database object'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.COLUMNNAME IS 'Name of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.MODE IS 'Type of column KEY|MAN|OPT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.DATATYPE IS 'Data type of column (BOOLEAN|CHAR|DATE|FIXED|FLOAT|INTEGER|LONG|SMALLINT|TIME|TIMESTAMP)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.CODETYPE IS 'Code attribute of column (ASCII|EBCDIC|BYTE|UNICODE)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.LEN IS 'Length or precision of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS."DEC" IS 'Number of places after the comma for columns of data type FIXED'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.NULLABLE IS 'Column can accept null value (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.COLUMNPRIVILEGES IS 'Privileges of current user for column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.DEFAULT IS 'Default value (DEFAULT) for column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.DEFAULTFUNCTION IS 'Name, if the DEFAULT value is one of the following value specifications: USER|TIME|TRUE|..., otherwise NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.DOMAINOWNER IS 'Name of domain owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.DOMAINNAME IS 'Name of domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.POS IS 'Original position of column in table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.KEYPOS IS 'Original position of key column in table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.PHYSICALPOS IS 'Position of the column on the disk'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.CREATEDATE IS 'Creation date of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.CREATETIME IS 'Creation time of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.ALTERDATE IS 'Change date of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.ALTERTIME IS 'Change time of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.TABLETYPE IS 'Type of table (SYSTEMS|TABLES)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.COMMENT IS 'Comment about column'""")

    # Table domain.connectedusers

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.CONNECTEDUSERS IS 'All connected users'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTEDUSERS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTEDUSERS.TERMID IS 'Terminal identification'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTEDUSERS.SESSION IS 'Session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTEDUSERS.CATALOG_CACHE_SIZE IS 'Size of cache for catalog information of this database'""")

    # Table domain.connectparameters

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.CONNECTPARAMETERS IS 'Connect parameters for current user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTPARAMETERS.SQLMODE IS 'SQLMODE'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTPARAMETERS.ISOLEVEL IS 'ISOLATION LEVEL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTPARAMETERS.TIMEOUT IS 'Value for session timeout'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTPARAMETERS.SESSION IS 'Session'""")

    # PTS 1116602

    # PTS 1105303

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONNECTPARAMETERS.SESSION IS 'Session'""")

    # Table domain.constraints

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.CONSTRAINTS IS '<constraint_definition> on accessible tables'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONSTRAINTS.OWNER IS 'Name of the table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONSTRAINTS.TABLENAME IS 'Name of table with CONSTRAINT definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONSTRAINTS.CONSTRAINTNAME IS 'Name of CONSTRAINT definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.CONSTRAINTS.DEFINITION IS 'Text of CONSTRAINT definition'""")

    # Table domain.dbprocedures

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.DBPROCEDURES IS 'Database procedures accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.OWNER IS 'Name of owner of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.DBPROCNAME IS 'Name of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.PACKAGE IS 'Package that contains the database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.PARAMETER IS 'Number of parameters of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.CREATEDATE IS 'Creation date of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.CREATETIME IS 'Creation time of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.EXECUTION_KIND IS 'Execution location of database procedure (INPROC|LOCAL|REMOTE)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.LANGUAGE IS 'Implementation language of the database procedure (spl|c++|java|...)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.SQL_SUPPORT IS 'Database procedure may contain SQL statements (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.WAIT_FOR_CHCKPT IS 'Database procedure waits for a checkpoint (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.REMOTE_LOCATION IS 'Execution location'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.DEFINITION IS 'SQL statement for defining the database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCEDURES.COMMENT IS 'Comment about database procedure'""")

    # Table domain.packages

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.PACKAGES IS 'Packages accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.OWNER IS 'Name of package owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.PACKAGE IS 'Name of package'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.CREATEDATE IS 'Creation date of package'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.CREATETIME IS 'Creation time of package'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.EXECUTION_KIND IS 'Execution location of database procedure (INPROC|LOCAL|REMOTE)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.SQL_SUPPORT IS 'Database procedures may contain SQL statements (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.REMOTE_LOCATION IS 'Execution location'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PACKAGES.COMMENT IS 'Comment about package'""")

    # Table domain.dbprocparaminfo

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.DBPROCPARAMINFO IS 'Parameters of a database procedure that is accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.OWNER IS 'Name of owner name of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.DBPROCEDURE IS 'Name of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.DATE IS 'Creation date of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.TIME IS 'Creation time of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.PARAM_NO IS 'Original position of parameter in database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.PARAMETERNAME IS 'Name of parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO."IN/OUT-TYPE" IS 'Type of parameter (IN|OUT)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.DATATYPE IS 'Datatype of parameter (BOOLEAN|CHAR|DATE|FIXED|FLOAT|TIME|TIMESTAMP)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.LEN IS 'Length or precision of parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO."DEC" IS 'Number of places after the comma for the parameter of data type FIXED'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.OFFSET IS 'Offset of a member of a C-struct with respect to kernel layout'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.ASCII_OFFSET IS 'Offset of a member of a C-struct with respect to a client using ASCII'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.UNICODE_OFFSET IS 'Offset of a member of a C-struct with respect to a client using UCS-2'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMINFO.CODE IS 'Code attribute of column (ASCII|EBCDIC|BYTE|UNICODE)'""")

    # Table domain.dbprocparams

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.DBPROCPARAMS IS 'Parameters of a database procedure that is accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.OWNER IS 'Name of owner of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.DBPROCNAME IS 'Name of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.PARAMETERNAME IS 'Name of parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.POS IS 'Original position of parameter in database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS."IN/OUT-TYPE" IS 'Type of parameter (IN|OUT)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.DATATYPE IS 'Datatype of parameter (BOOLEAN|CHAR|DATE|FIXED|FLOAT|TIME|TIMESTAMP)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.CODETYPE IS 'Code attribute of colume (ASCII|EBCDIC|BYTE)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.LEN IS 'Length or precision of parameter'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS."DEC" IS 'Number of places after the comma for the parameter of data type FIXED'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.CREATEDATE IS 'Creation date of database procedure'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DBPROCPARAMS.CREATETIME IS 'Creation time of database procedure'""")

    # Table domain.domains

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.DOMAINS IS 'All domains'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.OWNER IS 'Name of domain owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.DOMAINNAME IS 'Name of domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.DATATYPE IS 'Datatype of domain (BOOLEAN|CHAR|DATE|FIXED|FLOAT|INTEGER|LONG|SMALLINT|TIME|TIMESTAMP)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.CODETYPE IS 'Code attribute of domain (ASCII|EBCDIC|BYTE)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.LEN IS 'Length or precision of domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS."DEC" IS 'Number of places after the comma for domains of data type FIXED'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.DEFAULT IS 'Default value for domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.COLUMNS.DEFAULTFUNCTION IS 'Name, if the DEFAULT value is one of the following value specifications: USER|TIME|TRUE|..., otherwise NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.DEFINITION IS 'Text of domain definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.CREATEDATE IS 'Creation date of domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.CREATETIME IS 'Creation time of domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINS.COMMENT IS 'Comment about domain'""")

    # Table domain.domainconstraints

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.DOMAINCONSTRAINTS IS '<constraint_definition> for a domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINCONSTRAINTS.OWNER IS 'Name of domain owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINCONSTRAINTS.DOMAINNAME IS 'Name of domain'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINCONSTRAINTS.CONSTRAINTNAME IS 'Name of CONSTRAINT definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.DOMAINCONSTRAINTS.DEFINITION IS 'Text of CONSTRAINT definition'""")

    # Table domain.foreignkeys

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.FOREIGNKEYS IS '<referential_constraint_definition>s accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYS.FKEYNAME IS 'Name of referential CONSTRAINT definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYS.RULE IS 'Rules for deleting the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYS.CREATEDATE IS 'Creation date of referential CONSTRAINT definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYS.CREATETIME IS 'Creation time of referential CONSTRAINT definition>'""")

    # Table domain.foreignkeycolumns

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.FOREIGNKEYCOLUMNS IS 'columns of <referential_constraint_definition>s accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.COLUMNNAME IS 'Name of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.FKEYNAME IS 'Name of referential CONSTRAINT definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.REFOWNER IS 'Name of Owner of referenced table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.REFTABLENAME IS 'Name of referenced table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.REFCOLUMNNAME IS 'Name of column of referenced table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.RULE IS 'Rules for deleting the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.CREATEDATE IS 'Creation date of referential CONSTRAINT definition>'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.CREATETIME IS 'Creation time of referential CONSTRAINT definition>'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.FOREIGNKEYCOLUMNS.COMMENT IS 'Comment about referential CONSTRAINT definition'""")

    # Table domain.indexes

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.INDEXES IS 'Indexes accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.OWNER IS 'Name of index owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.INDEXNAME IS 'Name of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.TYPE IS 'Type of index (UNIQUE|NULL)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.INDEX_USED IS 'Usage frequency of index for searches'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.DISABLED IS 'Index not activated for searches (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.CREATEDATE IS 'Creation date of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.CREATETIME IS 'Creation time of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXES.COMMENT IS 'Comment about index'""")

    # Table domain.indexcolumns

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.INDEXCOLUMNS IS 'Indexes accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.OWNER IS 'Name of index owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.INDEXNAME IS 'Name of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.TYPE IS 'Type of index (UNIQUE|NULL)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.COLUMNNAME IS 'Name of column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.SORT IS 'Sort sequence for column (ASC|DESC)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.COLUMNNO IS 'Number of column in index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.DATATYPE IS 'Data type of column (BOOLEAN|CHAR|DATE|FIXED|FLOAT|INTEGER|LONG|SMALLINT|TIME|TIMESTAMP)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.LEN IS 'Length or precision of column definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.CREATEDATE IS 'Creation date of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.CREATETIME IS 'Creation time of index'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.INDEX_USED IS 'Usage frequency of index for searches'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.DISABLED IS 'Index not activated for searches (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.INDEXCOLUMNS.COMMENT IS 'Comment about index'""")

    # Table domain.locks

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.LOCKS IS 'Information about set locks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.SESSION IS 'ID of the database session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.TRANSCOUNT IS 'ID of the transaction in the database session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.PROCESS IS 'ID of the process in the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS."DATE" IS 'Create date of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS."TIME" IS 'Create time of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.TERMID IS 'ID of the user terminal'""")

    #COMMENT ON COLUMN DOMAIN.LOCKS.REMOTEUSER IS '"YES" for lock entries of remote SERVERDBs; otherwise, "NO"'

    #COMMENT ON COLUMN DOMAIN.LOCKS.PENDINGLOCK IS '"YES" for "pending" locks; otherwise, "NO"'

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.LASTWRITE IS 'Time that has elapsed since the last SQL statement for data manipulation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.LOCKMODE IS 'Type of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.LOCKSTATE IS 'Status of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.APPLPROCESS IS 'ID of the process of the client hardware'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.APPLNODE IS 'ID of the client hardware'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.OWNER IS 'Table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.TABLEID IS 'Table ID'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.ROWIDLENGTH IS 'Length of key of the locked row'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.ROWIDHEX IS 'Start of the key of the locked row in hexadecimal format'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCKS.ROWID IS 'Start of key of the locked row'""")

    # Table domain.lock_holder

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.LOCK_HOLDER IS 'Information about lock holder used by database manager tools'""")

    # Table domain.lock_requestor

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.LOCK_REQUESTOR IS 'Information about lock requestor used by database manager tools'""")

    # Table domain.lock_waits

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.LOCK_WAITS IS 'Information about requested locks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.TABLENAME IS 'Table name'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.TABLEID IS 'Table identifier'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_TERMID IS 'Identifier for the terminal of the lock holding user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_PROCESS IS 'Process identifier of lock holding user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_APPLPROCESS IS 'Identifier of lock holding application process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_APPLNODE IS 'Identifier of client machine of lock holding application process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_ROWIDHEX IS 'Prefix of key of locked row in hexadecimal representation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_ROWID IS 'Prefix of key of locked row'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_LOCKMODE IS 'Lock mode'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_DATE IS 'Create date of the lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_TIME IS 'Create time of the lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.H_LOCKTIMEOUT IS 'Always NULL'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_TERMID IS 'Identifier for the terminal of the lock requesting user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_PROCESS IS 'Process identifier of lock requesting user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_APPLPROCESS IS 'Identifier of lock requesting application process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_APPLNODE IS 'Identifier of client machine of lock requesting application process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_ROWIDHEX IS 'Prefix of key of requested row in hexadecimal representation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_ROWID IS 'Prefix of key of requested row'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_REQMODE IS 'Lock request mode'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_DATE IS 'Create date of the request'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_TIME IS 'Create time of the request'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.LOCK_WAITS.R_REQTIMEOUT IS 'Time remaining up to the REQUEST_TIMEOUT in seconds'""")

    # Table domain.mapcharsets

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.MAPCHARSETS IS 'All MAPCHAR SETs'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.MAPCHARSETS.MAPCHARSETNAME IS 'Name of the MapChar set'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.MAPCHARSETS.CODE IS 'Code attribute for which the MapChar set was defined (ASCII|EBCDIC)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.MAPCHARSETS.INTERN IS 'Original form in hexadecimal format'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.MAPCHARSETS.MAP_CODE IS 'Target form in hexadecimal format'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.MAPCHARSETS.MAP_CHARACTER IS 'Target form in plain text format'""")

    # Table domain.parameters

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.PARAMETERS IS 'Used for system internal purposes (DDL trigger)'""")

    # table domain.schemas

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SCHEMAS IS 'Schemas accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SCHEMAS.SCHEMA_NAME IS 'Schema name'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SCHEMAS.SCHEMA_HANDLE IS 'Unique number of the schema'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SCHEMAS.CREATEDATE IS 'Creation date of the schema'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SCHEMAS.CREATETIME IS 'Creation time of the schema'""")

    # Table domain.sequences

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SEQUENCES IS 'Sequences accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.OWNER IS 'Name of sequence owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.SEQUENCE_NAME IS 'Name of the sequence'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.MIN_VALUE IS 'Minimum value of the sequence'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.MAX_VALUE IS 'Maximum value of the sequence'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.INCREMENT_BY IS 'Value by which the sequence is increased'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.CYCLE_FLAG IS 'Does the sequence begin again with the minimum value once the maximum value has been reached?'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.ORDER_FLAG IS 'Are the sequence values granted in the order of the request?'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.CACHE_SIZE IS 'Number of sequence values loaded into the cache simultaneously'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.LAST_NUMBER IS 'Last sequence value that was saved'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.CREATEDATE IS 'Creation date of the sequence'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.CREATETIME IS 'Creation time of the sequence'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SEQUENCES.COMMENT IS 'Comment about the sequence'""")

    # Table domain.synonyms

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYNONYMS IS 'Synonyms accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.OWNER IS 'Name of synonym owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.SYNONYMNAME IS 'Name of synonym'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.PUBLIC IS 'Synonym is PUBLIC (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.TABLEOWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.CREATEDATE IS 'Creation date of the synonym'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.CREATETIME IS 'Creation time of the synonym'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYNONYMS.COMMENT IS 'Comment about synonym'""")

    # Table domain.tables

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.TABLES IS 'Tables, views, synonyms, results accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.PRIVILEGES IS 'Privileges of current user for table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.TYPE IS 'Type of table (SYSTEMS|TABLES)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.TABLETYPE IS 'Table type (TABLE|VIEW|SYNONYM|RESULT)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.CREATEDATE IS 'Creation date of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.CREATETIME IS 'Creation time of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.UPDSTATDATE IS 'Date of the last UPDATE STATISTICS statement for table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.UPDSTATTIME IS 'Time of the last UPDATE STATISTICS statement for table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.ALTERDATE IS 'Change date of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.ALTERTIME IS 'Change time of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.UNLOADED IS 'Table is unloaded (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.SAMPLE_PERCENT IS 'Percentage of the table that is updated when updating statistics'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.SAMPLE_ROWS IS 'Number of rows in the table that are updated when updating statistics'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.COMMENT IS 'Comment about table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.TABLEID IS 'Table ID in hexadecimal format'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.DYNAMIC IS 'Table was defined with DYNAMIC option'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLES.ARCHIVE IS 'Table was defined with FOR ARCHIVE option'""")

    # Table domain.tableprivileges

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.TABLEPRIVILEGES IS 'All table privileges of the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLEPRIVILEGES.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLEPRIVILEGES.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLEPRIVILEGES.GRANTOR IS 'Name of the user who granted the privileges'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLEPRIVILEGES.GRANTEE IS 'Name of the user of the role that was granted the privilege'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLEPRIVILEGES.PRIVILEGE IS 'Privileges that were granted'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TABLEPRIVILEGES.IS_GRANTABLE IS 'Privilege to grant the received privilege to another user/role (YES|NO)'""")

    # PTS 1116602

    # Table domain.triggers

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.TRIGGERS IS 'Triggers accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.OWNER IS 'Name of the table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.TABLENAME IS 'Name of the table for which the trigger was defined'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.TRIGGERNAME IS 'Name of trigger'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.INSERT IS 'Type of trigger'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.UPDATE IS 'Type of trigger'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.DELETE IS 'Type of trigger'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.CREATEDATE IS 'Creation date of trigger'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.CREATETIME IS 'Creation time of trigger'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.DEFINITION IS 'Text of trigger definition'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.TRIGGERS.COMMENT IS 'Comment about trigger'""")

    # Table domain.users

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.USERS IS 'All users'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.OWNER IS 'Name of user owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.GROUPNAME IS 'Name of group'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.USERMODE IS 'Class of user (SYSDBA|DBA|RESOURCE|STANDARD)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.CONNECTMODE IS 'Type of connection (MULTIPLE|SINGLE)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.MAXTIMEOUT IS 'Value of TIMEOUT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.COSTWARNING IS 'Value of COSTWARNING'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.COSTLIMIT IS 'Value of COSTLIMIT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.DEFAULTCODE IS 'Default value for code attribute'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.CREATEDATE IS 'Creation date of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.CREATETIME IS 'Creation time of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.ALTERDATE IS 'Change date of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.ALTERTIME IS 'Change time of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.PWCREADATE IS 'Creation date of password'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.PWCREATIME IS 'Creation time of password'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.SERVERDB IS 'Name of database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.SERVERNODE IS 'Host node name of database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.USER_ID IS 'ID of the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.USERS.COMMENT IS 'Comment about user'""")

    # Table domain.versions

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.VERSIONS IS 'Version'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VERSIONS.KERNEL IS 'Version of the SAP DB database software'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VERSIONS.RUNTIMEENVIRONMENT IS 'Version of the runtime environment'""")

    # Table domain.views

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.VIEWS IS 'View tables accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.OWNER IS 'Name of the owner of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.VIEWNAME IS 'Name of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.PRIVILEGES IS 'Privileges of the user for view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.TYPE IS 'Type of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.CREATEDATE IS 'Creation date of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.CREATETIME IS 'Creation time of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.ALTERDATE IS 'Change date of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.ALTERTIME IS 'Change time of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.UPDSTATDATE IS 'Date of the last UPDATE STATISTICS statement for the view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.UPDSTATTIME IS 'Time of the last UPDATE STATISTICS statement for the view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.UNLOADED IS 'View table is unloaded (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWS.COMMENT IS 'Comment about view table'""")

    # Table domain.viewcolumns

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.VIEWCOLUMNS IS 'Columns in view tables accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.OWNER IS 'Name of the owner of the view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.VIEWNAME IS 'Name of the view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.VIEWCOLUMNNAME IS 'Name of column in view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.TABLEOWNER IS 'Name of owner of table that the used column belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.TABLENAME IS 'Name of the table that the used column belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.COLUMNNAME IS 'Original name of the column in the table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.CREATEDATE IS 'Creation date of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWCOLUMNS.CREATETIME IS 'Creation time of view table'""")

    # Table domain.viewdefs

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.VIEWDEFS IS 'Definition of a view table accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWDEFS.OWNER IS 'Name of the owner of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWDEFS.VIEWNAME IS 'Name of the view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWDEFS.LEN IS 'Length of the definition of view table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.VIEWDEFS.DEFINITION IS 'Text of the definition of view table'""")


    # table domain.session_roles

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SESSION_ROLES IS 'All roles enabled for the current session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SESSION_ROLES.ROLE IS 'Name of role'""")


    # table domain.roles

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.ROLES IS 'All roles accessible to the user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.OWNER IS 'Name of role owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.ROLE IS 'Name of role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.PASSWORD_REQUIRED IS 'Password required for activating the role (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.GRANTED IS 'Role was granted to current user (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.DEFAULTROLE IS 'Role is default role for the current user (YES|NO)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.CREATEDATE IS 'Creation date of the role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLES.CREATETIME IS 'Creation time of the role'""")


    # table domain.roleprivileges

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.ROLEPRIVILEGES IS 'Privileges granted to roles'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.OWNER IS 'Name of the owner of the object that was granted for the role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.TABLENAME IS 'Name of the table for which privileges were granted for the role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.ROLE IS 'Name of the role that was granted'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.GRANTEE IS 'Name of the role to which has been granted'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.PRIVILEGES IS 'Privileges that were granted'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.GRANTOR IS 'Name of the user who granted the privileges or the role'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.CREATEDATE IS 'Date when the privileges were granted'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.ROLEPRIVILEGES.CREATETIME IS 'Time when the privileges were granted'""")


    loaderCmd (session, 'COMMIT')

    # Table domain.sysmon_backupioaccess

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_BACKUPIOACCESS IS 'I/O done during backup/restore'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.DEVICEID IS 'Identification of the device'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.DEVICENAME IS 'Name of the device'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.BACKUPREADS IS 'Number of read calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.BACKUPWRITES IS 'Number of write calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.BACKUPPAGES IS 'Number of pages read/written'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.QUEUELEN IS 'Number of pending I/O calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_BACKUPIOACCESS.QUEUEMAX IS 'Maximal number of pending I/O calls'""")

    # Table domain.sysmon_connection

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_CONNECTION IS 'Connections between applications and the kernel'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.TASKINDEX IS 'Id of the kernel task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.UKTID IS 'Id of the UKT the kernel task resides in'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.APPLPID IS 'Id of the application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.PEERPID IS 'Id of the communication partner of the kernel task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.TASKNAME IS 'Name of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.CONNECTSTATE IS 'State of the connection'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.CONNECTTIME IS 'Time the connection was created'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_CONNECTION.REMOTEAPPLNODE IS 'Id of the node the application is on'""")

    # Table domain.sysmon_iothread

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_IOTHREAD IS 'I/O done by each thread on each volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.OSPID IS 'Identification of the thread in the OS'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.THREADNAME IS 'Name of the thread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.VOLUMEID IS 'Number of the volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.VOLUMENAME IS 'Name of the volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.READS IS 'Number of read calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.WRITES IS 'Number of write calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.QUEUELEN IS 'Number of pending I/O calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOTHREAD.QUEUEMAX IS 'Maximal number of pending I/O calls'""")

    # Table domain.sysmon_ioaccess

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_IOACCESS IS 'I/O done on each volume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOACCESS.DEVICEID IS 'Identification of the device'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOACCESS.DEVICENAME IS 'Name of the device'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOACCESS.READS IS 'Number of read calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOACCESS.READPAGES IS 'Number of pages read'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOACCESS.WRITES IS 'Number of write calls'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_IOACCESS.WRITEPAGES IS 'Number of pages written'""")

    # Table domain.sysmon_region

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_REGION IS 'Region accesses'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.REGID IS 'Identification of the region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.REGIONNAME IS 'Name of the region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.OWNERDBPID IS 'Task holding the region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.REQSTDBPID IS 'Task requesting the region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.ACCESSES IS 'Number of accesses to this region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.TEST_AND_SET IS 'Number of collisions on an internal mechanism during handling of this region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.COLLISIONS IS 'Number of collisions between one task holding the region and another one requesting it'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.COLLISION_RATE IS 'Percentage of accesses which collided'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.WAITS IS 'Number of collisions which result in joining the waiting queue for this region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_REGION.LOCKED IS 'Currently colliding on internal mechanism during handling of this region'""")

    # Table domain.sysmon_special_thread

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_SPECIAL_THREAD IS 'Special threads'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SPECIAL_THREAD.OSPID IS 'Identification of the thread in the OS'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SPECIAL_THREAD.THREADNAME IS 'Name of the thread'""")

    # Table domain.sysmon_storage

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_STORAGE IS 'Storage needed/unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_STORAGE.DESC IS 'Description'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_STORAGE.VAL IS 'Value'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_STORAGE.VDESC IS 'Unit of the value (KB/pages)'""")

    # Table domain.sysmon_ukthread

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_UKTHREAD IS 'Threads containing tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.OSPID IS 'Identification of the thread in the OS'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.THREADNAME IS 'Name of the thread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.DISPATCHCNT IS 'Number of assigments of the CPU to tasks in this UKT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.COMMANDCNT IS 'Number of SQL commands of tasks in this UKT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.TASKS_ACTIVE IS 'Number of currently active tasks in this UKT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.TASKS_TOTAL IS 'Maximum number of tasks in this UKT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_UKTHREAD.TASKCLUSTER IS 'Specification of numbers and types of tasks in this UKT'""")

    # Table domain.sysmon_task

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_TASK IS 'State and requested resources of tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.OMSCALLACTIVE IS 'Task is working within an OMS call'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.TIMEOUT IS 'For user tasks only: request time left'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_active_task

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_ACTIVE_TASK IS 'State and requested resources of active tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.TIMEOUT IS 'For user tasks only: request time left'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_ACTIVE_TASK.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_runnable

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_RUNNABLE IS 'State and requested resources of active tasks and tasks which could be active'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.TIMEOUT IS 'For user tasks only: request time left'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_RUNNABLE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_us

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_US IS 'State and requested resources of user tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.TIMEOUT IS 'Request time left'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_us_active

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_US_ACTIVE IS 'State and requested resources of active user tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.TIMEOUT IS 'Request time left'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_ACTIVE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_us_runnable

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_US_RUNNABLE  IS 'State and requested resources of active user tasks and user tasks which could be active'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.TIMEOUT IS 'Request time left'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_US_RUNNABLE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_sv

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_SV IS 'State and requested resources of server tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.TIMEOUT IS 'Unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_sv_active

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_SV_ACTIVE IS 'State and requested resources of active server tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.TIMEOUT IS 'Unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_ACTIVE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_sv_runnable

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_SV_RUNNABLE IS 'State and requested resources of active server tasks and server tasks which could be active'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.TIMEOUT IS 'Unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_SV_RUNNABLE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_dw

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_DW IS 'State and requested resources of datawriter tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.TIMEOUT IS 'Unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_dw_active

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_DW_ACTIVE IS 'State and requested resources of active datawriter tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.TIMEOUT IS 'Unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_ACTIVE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_dw_runnable

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_DW_RUNNABLE IS 'State and requested resources of active datawriter tasks and datawriter tasks which could be active'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.OSPID IS 'Identification of the thread in the OS this task belongs to'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.TASKTYPE IS 'Type of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.APPID IS 'Identification of connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.CANCEL_FLAG IS 'Task is flagged for cancelling the current operation'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.SPECIAL_FLAG IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.TIMEOUT IS 'Unused'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.REGID IS 'Number of regions currently hold'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.WAITING4TASK IS 'Id of the task holding resources this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.WAITING4ROOT IS 'Id of the tree (root) this task is waiting for'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_DW_RUNNABLE.EXTENDEDTASKSTATE IS 'Additional information about the task state'""")

    # Table domain.sysmon_task_detail

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_TASK_DETAIL IS 'Details for each task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.DBPID IS 'Identification of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.TASKNAME IS 'Name of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.STATEDESC IS 'State of the task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.APPL_NODEID IS 'Hostname of the remote connected application'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.APPL_PROCESS IS 'Identification of the connected application in the OS '""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.DISPATCHCNT IS 'Number of assigments of the CPU to this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.COMMANDCNT IS 'Number of SQL commands of this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.PRIOCNT IS 'Number of requests for increasing the task priority'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.TASKSELFSUSPCNT IS 'Number of voluntary releases of the CPU in favour of other tasks in this UKT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.REGIONACCESSCNT IS 'Number of region accesses'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOREADCNT IS 'Number of read calls done by this task (no request to iothreads)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOREADPAGES IS 'Number of pages read during SIOREADCNT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOREADAVGABSTIME IS 'Average time needed for each read operation done by this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOREADTOTABSTIME IS 'Total time needed for each read operation done by this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOWRITECNT IS 'Number of write calls done by this task (no request to iothreads)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOWRITEPAGES IS 'Number of pages written during SIOWRITECNT'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOWRITEAVGABSTIME IS 'Average time needed for each write operation done by this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.SIOWRITETOTABSTIME IS 'Total time needed for each write operation done by this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOREADCNT IS 'Number of read calls requested by this task and done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOREADPAGES IS 'Number of pages read by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOREADAVGRELTIME IS 'Average time needed for each read operation done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOREADTOTRELTIME IS 'Total time needed for each read operation done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOREADAVGABSTIME IS 'Average waiting time between read request and getting the reply'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOREADTOTABSTIME IS 'Total waiting time between read request and getting the reply'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOWRITECNT IS 'Number of write calls requested by this task and done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOWRITEPAGES IS 'Number of pages written by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOWRITEAVGRELTIME IS 'Average time needed for each write operation done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOWRITETOTRELTIME IS 'Total time needed for each write operation done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOWRITEAVGABSTIME IS 'Average waiting time between write request and getting the reply'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.IOWRITETOTABSTIME IS 'Total waiting time between write request and getting the reply'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPREADCNT IS 'Number of read calls during backup requested by this task and done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPREADPAGES IS 'Number of pages read by a iothread during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPREADAVGRELTIME IS 'Average time needed for each read operation done by a iothread during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPREADTOTRELTIME IS 'Total time needed for each read operation done by a iothread during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPREADAVGABSTIME IS 'Average waiting time between read request and getting the reply during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPREADTOTABSTIME IS 'Total waiting time between read request and getting the reply during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPWRITECNT IS 'Number of write calls during backup requested by this task and done by a iothread'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPWRITEPAGES IS 'Number of pages written by a iothread during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPWRITEAVGRELTIME IS 'Average time needed for each write operation done by a iothread during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPWRITETOTRELTIME IS 'Total time needed for each write operation done by a iothread during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPWRITEAVGABSTIME IS 'Average waiting time between write request and getting the reply during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.BKPWRITETOTABSTIME IS 'Total waiting time between write request and getting the reply during backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSUSPENDCNT IS 'Number of suspends for this task'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSUSPENDAVGRELTIME IS 'Average time for each suspend'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSUSPENDTOTRELTIME IS 'Total time for each suspend'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSUSPENDAVGABSTIME IS 'Average waiting time between suspending itself and getting the resume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSUSPENDTOTABSTIME IS 'Total waiting time between suspending itself and getting the resume'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VWAITCNT IS 'Number of waits for releasing SQL locks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VWAITAVGRELTIME IS 'Average waiting time for a lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VWAITTOTRELTIME IS 'Total waiting time for a lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VWAITAVGABSTIME IS 'Average waiting time between suspending itself and getting the lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VWAITTOTABSTIME IS 'Total waiting time between suspending itself and getting the lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSLEEPCNT IS 'Number of sleep requests'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSLEEPAVGRELTIME IS 'Average sleeping time'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSLEEPTOTRELTIME IS 'Total sleeping time'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSLEEPAVGABSTIME IS 'Average time between starting of sleep and being awakened'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.VSLEEPTOTABSTIME IS 'Total time between starting of sleep and being awakened'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.CMDCNT IS 'Number of SQL commands during time measurement'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.AVGCMDEXECUTETIME IS 'Average command execution time'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.TOTCMDEXECUTETIME IS 'Total command execution time'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.AVGCMDWAITRELTIME IS 'Average time waiting for SQL command'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.TOTCMDWAITRELTIME IS 'Total time waiting for SQL command'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.AVGCMDWAITABSTIME IS 'Average time between begin of waiting and starting the execution'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.TOTCMDWAITABSTIME IS 'Total time between begin of waiting and starting the execution'""")

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = 'INSTANCE_TYPE'
        AND "VALUE" = 'LVC'""")

    if rc == 0:

        stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.OMSCOMROUTINENAME IS 'Name of the COM routine currently executed by this task'""")

        stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.OMSCALLBACKCOUNT IS 'Number of callbacks executed inside the currently running COM routine back to the liveCache kernel'""")

        stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TASK_DETAIL.OMSCALLBACKMETHOD IS 'Name of the currently executed callback method called by the COM routine back to the liveCache kernel'""")

    # Table domain.sysmon_totalcount

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.SYSMON_TOTALCOUNT IS 'Sum of task statistics of all tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.DISPATCHCNT IS 'Sum of assigments of the CPU to tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.COMMANDCNT IS 'Sum of SQL commands'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.VWAITCNT IS 'Sum of waits for releasing SQL locks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.VSUSPENDCNT IS 'Sum of suspends'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.VSLEEPCNT IS 'Sum of sleep requests'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.PRIOCNT IS 'Sum of requests for increasing the task priority'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.USERTASKREADCNT IS 'Sum of read calls requested by user tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.USERTASKWRITECNT IS 'Sum of write calls requested by user tasks'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.TASKIOCNT IS 'Sum of I/Os done by all tasks (no request to iothreads)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.IOCNT IS 'Sum of I/Os done by all iothreads'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.REGIONACCESSCNT IS 'Sum of region accesses'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.REGIONCOLLCNT IS 'Sum of regions accesses which collided'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.REGIONWAITCNT IS 'Sum of collisions which result in joining the waiting queue of a region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.VBEGEXCLTASCOLLCNT IS 'Sum of collisions on an internal mechanism during entering any region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.VENDEXCLTASCOLLCNT IS 'Sum of collisions on an internal mechanism during leaving any region'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.SYSMON_TOTALCOUNT.TASKSELFSUSPCNT IS 'Sum of voluntary releases of the CPU in favour of other tasks in the same UKT'""")

    # Table domain.parsinfos

    stopIfSqlNotOK (session, """COMMENT ON TABLE DOMAIN.PARSINFOS IS 'Parsinformation of this session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PARSINFOS.SYSINFOKEY IS 'Key of the information'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PARSINFOS.KEY_SEQ IS 'Number of part of the information'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PARSINFOS.NAME1 IS 'Name with meaning dependend on TABLETYPE'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PARSINFOS.NUMERIC_VALUE IS 'Number with meaning dependend on TABLETYPE'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PARSINFOS.TABLETYPE IS 'Type of the information'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN DOMAIN.PARSINFOS.SIZE IS 'Length of the information'""")

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


