#SAY --- Installing SQL catalog views ...
#/
#/ Alle Tabellen, die mit # beginnen loeschen
#/ Die #-Tabellen sind Basis-Tabellen und wurden von Tools mit Hilfe
#/ Stored Procedures gefuellt (SQL-PL). Ab 7.2 wird die Funktionalitaet
#/ fallengelassen.
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


#/ #FOREIGNKEY: vorher SELECT ... DISTINCT in zwei Schritten auf SYSDD.FOREIGN_KEYS jetzt in einem Schritt
#/ #LITERAL
#/ #MODULE
#/ #MOD_CALL_DBP
#/ #MOD_CALL_MOD
#/ #MOD_USES_COL
#/ #MOD_USES_DOM
#/ #MOD_USES_QCM
#/ #MOD_USES_TAB
#/ #PROGRAM
#/ #PRO_CONT_MOD
#/ #QCM_USES_COL
#/ #QCM_USES_TAB
#/ #QPCOMMAND
#/ #QPC_USES_COL
#/ #QPC_USES_TAB
#/ #QPEXCELLINK
#/ #QPE_USES_QPC
#/ #QPE_USES_QPQ
#/ #QPQUERY
#/ #QPQ_USES_COL
#/ #QPQ_USES_TAB
#/ #QPWORDLINK
#/ #QPW_USES_QPC
#/ #QPW_USES_QPQ
#/ #QUERYCOMMAND
#/ #USR_USES_PRO
#/ #USR_USES_QCM
#/ #USR_USES_QPC
#/ #USR_USES_QPE
#/ #USR_USES_QPQ
#/ #USR_USES_QPW

#/ Alle Tabellen, die mit $ beginnen loeschen
#/
#/ $COLUMN
#/ $DBFUNCTION
#/ $DBPROCEDURE
#/ $DOMAIN
#/ $FOREIGNKEY
#/ $INDEX
#/ $LITERAL
#/ $MODULE
#/ $PROGRAM
#/ $QPCOMMAND
#/ $QPEXCELLINK
#/ $QPQUERY
#/ $QPWORDLINK
#/ $QUERYCOMMAND
#/ $SEQUENCE
#/ $SYNONYM
#/ $TABLE
#/ $TRIGGER
#/ $USER
#/
#/ Zu loeschen sind:
#/ Objekt MODULE und Beziehungen
#/ Objekt DBFUNCTION und Beziehungen
#/ Objekt DESIGN und Beziehungen
#/ Objekt LITERAL und Beziehungen
#/ Objekt PROGRAM und Beziehungen
#/ Objekt QPCOMMANDS und Beziehungen
#/ Objekt QP* und Beziehungen
#/
#/ Wir trennen uns von den Beziehungsviews. Es werden in den Tools nur noch Beziehungen
#/ dargestellt, die im Tool explizit ausprogrammiert sind. Ein allgemeiner Ansatz, wie
#/ beim frueheren DOMAIN besteht nicht mehr.
#/ Demnach entfallen die Views:
#/ COL_REFS_DOM
#/ COL_USES_COL  1)
#/ DBP_CONT_PRM
#/ FKC_REFS_COL  2)
#/ FOK_REFS_TAB  2)
#/ FOK_USES_COL  2)
#/ IND_USES_COL  3)
#/ SYN_REFS_TAB
#/ SYN_REFS_VIE
#/ TAB_CONT_COL
#/ TAB_CONT_FOK
#/ TAB_CONT_IND
#/ TAB_CONT_TRG
#/ TAB_USES_CON
#/ TRG_CONT_PRM
#/ USR_OWNS_DOM
#/ USR_OWNS_USR
#/ USR_USES_COL
#/ USR_USES_DBP
#/ USR_USES_TAB
#/ USR_USES_VIE
#/ VIE_CONT_COL
#/ VIE_USES_SYN
#/ VIE_USES_TAB
#/ VIE_USES_VIE
#/
#/ Die mit 1), 2), 3) bezeichneten Beziehungsviews enthalten Informationen, die bislang
#/ in keiner anderen DOMAIN-Tabelle zur Verfuegung standen. Diese Informationen werden
#/ nun in den folgenden neu hinzugekommenen DOMAIN-Tabellen angeboten:
#/ 1) DOMAIN.VIEWCOLUMNS       -> SYSDD.REFERENCED_COLUMNS
#/ 2) DOMAIN.FOREIGNKEYCOLUMNS -> SYSDD.FOREIGN_KEYS
#/ 3) DOMAIN.INDEXCOLUMNS      -> SYSDD.INDEXES
#/
#/
#/ Die Selbstbeschreibbarkeit der Objekte und Beziehungen entfaellt
#/ mit dem nicht mehr vorhandenen Anspruch ein allgemeines Tool fuer
#/ die Darstellung von Objekten und Beziehungen bereitstellen zu wollen.
#/
#/ Daher werden folgende Views geloescht:
#/
#/ OBJECT_DESC
#/ RELSHIP_DESC
#/ OBJECT_TYPE
#/ RELSHIP_TYPE
#/ RELATION_TYPE
#/
#/ Spaltenprivilegien wollen wir im Vorgriff auf 7.3 Tool-seitig nicht
#/ mehr unterstuetzen daher entfaellt die View:
#/ COLUMNPRIVILEGES
#/ und die Spalte
#/ DOMAIN.COLUMNS.COLUMNPRIVILEGES
#/
#/ Alles, was mit Verteilung zu tun hat, kann weg:
#/ DOMAIN.SERVERDBS
#/ =====================================================
#/ @(#) XDD.py                     7.2.01.02   1999-10-05
#/ =====================================================
#/
from installib import *

def install (session,options):
    """Installing DOMAIN tables
    """

    loaderCmd (session, 'USE USER DOMAIN %s' % options.dompwd)

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.OMS_VERSIONS')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_OWNS_DBL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DATABASELINKS')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SNAPSHOTS')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SNAPSHOTDEFS')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.MOD_USES_SNP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.QCM_USES_SNP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.QPC_USES_SNP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.QPQ_USES_SNP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SNP_CONT_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SNP_USES_SYN')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SNP_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SNP_USES_VIE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SYN_REFS_SNP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_USES_SNP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.VIE_USES_SNP')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBFUNCPARAMS')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBFUNCTIONS')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBF_CONT_PRM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBF_REFS_MOD')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBF_USES_MOD')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBF_USES_MOD')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#FOREIGNKEY')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#LITERAL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MODULE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MOD_CALL_DBP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MOD_CALL_MOD')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MOD_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MOD_USES_DOM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MOD_USES_QCM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#MOD_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#PROGRAM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#PRO_CONT_MOD')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QCM_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QCM_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPCOMMAND')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPC_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPC_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPEXCELLINK')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPE_USES_QPC')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPE_USES_QPQ')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPQUERY')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPQ_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPQ_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPWORDLINK')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPW_USES_QPC')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QPW_USES_QPQ')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#QUERYCOMMAND')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#USR_USES_PRO')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#USR_USES_QCM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#USR_USES_QPC')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#USR_USES_QPE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#USR_USES_QPQ')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.#USR_USES_QPW')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$COLUMN')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$DBFUNCTION')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$DBPROCEDURE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$DOMAIN')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$FOREIGNKEY')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$INDEX')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$LITERAL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$MODULE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$PROGRAM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$QPCOMMAND')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$QPEXCELLINK')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$QPQUERY')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$QPWORDLINK')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$QUERYCOMMAND')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$SEQUENCE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$SYNONYM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$TABLE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$TRIGGER')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.$USER')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.COL_REFS_DOM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.COL_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.DBP_CONT_PRM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.FKC_REFS_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.FOK_REFS_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.FOK_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.IND_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SYN_REFS_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.SYN_REFS_VIE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.TAB_CONT_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.TAB_CONT_FOK')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.TAB_CONT_IND')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.TAB_CONT_TRG')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.TAB_USES_CON')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.TRG_CONT_PRM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_OWNS_DOM')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_OWNS_USR')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_USES_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_USES_DBP')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.USR_USES_VIE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.VIE_CONT_COL')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.VIE_USES_SYN')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.VIE_USES_TAB')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.VIE_USES_VIE')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.OBJECT_DESC')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.RELSHIP_DESC')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.OBJECT_TYPE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.RELSHIP_TYPE')
    stopIfSqlNotErr (session, -4004, 'DROP VIEW DOMAIN.RELATION_TYPE')

    createReplaceView (session, 'DOMAIN.PARAMETERS',
        """AS SELECT *
           FROM SYSDD.PARAMETERS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.PARAMETERS TO PUBLIC')

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = 'INSTANCE_TYPE'
        AND "VALUE" = 'LVC'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.CLASSCONTAINERS',
            """(GUID, CLASS_NAME, SCHEMA, CONTAINERNO, CLASS_ID, SIZE,
                PAGECOUNT, FREE_PAGES, EMPTY_PAGES, KEY_LEAF_PAGES,
                OBJECTS_PER_PAGE, GARBAGEOBJCHECKED, GARBAGEOBJRELEASED,
               "OCCUPANCY (%)", FREE_EOT_PAGES)
            AS SELECT
              GUID, CLASS_NAME, SCHEMA, CONTAINERNO, CLASS_ID, SIZE,
              PAGECOUNT, FREE_PAGES, EMPTY_PAGES, KEY_LEAF_PAGES,
              FIXED(NULL,10), GARBAGEOBJCHECKED, GARBAGEOBJRELEASED,
              OCCUPANCY, FIXED(NULL, 10)
            FROM SYSDD.CONTAINERS
            INTERNAL""")

        stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CLASSCONTAINERS TO PUBLIC WITH GRANT OPTION')

        createReplaceView (session, 'DOMAIN.CLASSCONTAINER_ROOTS',
            """(CLASS_ID,
                SEQUELCONTAINER,
                ROOT,
                KEY_PARTITIONCOUNT,
                VAROBJ_CONTAINER,
                DELETED,
                MAX_OBJBODYSIZE,
                MAX_OBJPERPAGE,
                MAX_CHAINS,
                UNUSED_BYTEPERPAGE)
            AS SELECT
                CLASS_ID,
                SEQUELCONTAINER,
                ROOT,
                KEY_PARTITIONCOUNT,
                VAROBJ_CONTAINER,
                DELETED,
                MAX_OBJBODYSIZE,
                MAX_OBJPERPAGE,
                MAX_CHAINS,
                UNUSED_BYTEPERPAGE
            FROM SYSDD.CONTAINER_ROOTS
            INTERNAL""")

        stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CLASSCONTAINER_ROOTS TO PUBLIC WITH GRANT OPTION')

        createReplaceView (session, 'DOMAIN.CLASSCONTAINER_CHAINS',
            """(CLASS_ID,
                SEQUELCONTAINER,
                CHAIN_ID,
                SUBROOT,
                OBJECTCOUNT,
                PAGECOUNT,
                ACTIVE_GC_TASKID,
                RELEASEEMPTYPAGES)
            AS SELECT
                CLASS_ID,
                SEQUELCONTAINER,
                CHAIN_ID,
                SUBROOT,
                OBJECTCOUNT,
                PAGECOUNT,
                ACTIVE_GC_TASKID,
                RELEASEEMPTYPAGES
            FROM SYSDD.CONTAINER_CHAINS
            INTERNAL""")

        stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CLASSCONTAINER_CHAINS TO PUBLIC WITH GRANT OPTION')

        createReplaceView (session, 'DOMAIN.CLASSCONTAINER_KEYS',
            """(CLASS_ID, KEY_PARTITION, KEY_ROOT)
            AS SELECT
             CLASS_ID, KEY_PARTITION, KEY_ROOT
            FROM SYSDD.CONTAINER_KEYS
            INTERNAL""")

        stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CLASSCONTAINER_KEYS TO PUBLIC WITH GRANT OPTION')


        createReplaceView (session, 'DOMAIN.OMS_VERSIONS',
            """(OMS_VERSION_ID,
               CREATE_DATE,
               CREATE_TIME,
               TRANSVERSION,
               MARKED,
               AGE_IN_HOURS,
               UNLOADED,
               HEAP_USAGE,
               PAGECOUNT,
               VERSION_DESC
              )
            AS SELECT
               OMS_VERSION_ID,
               "DATE",
               "TIME",
               TRANSVERSION,
               DECODE (MARKED, 'YES', 'X', ' '),
               FIXED (NUM (SUBSTR (TIMEDIFF (TIMESTAMP("DATE", "TIME"), TIMESTAMP),1,4)), 4),
               UNLOADED,
               "HEAPSIZE (BYTES)",
               PAGECOUNT,
               VERSION_DESC
            FROM SYSDD.OMS_VERSIONS
            INTERNAL""")

        stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.OMS_VERSIONS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.COLUMNS',
        """(OWNER,TABLENAME,COLUMNNAME,MODE,DATATYPE,CODETYPE,LEN,"DEC",NULLABLE,
           COLUMNPRIVILEGES,"DEFAULT","DEFAULTFUNCTION",DOMAINOWNER,DOMAINNAME,POS,KEYPOS,PHYSICALPOS,
           CREATEDATE,CREATETIME,ALTERDATE,ALTERTIME,TABLETYPE,COMMENT)
        AS SELECT
             OWNER,TABLENAME,COLUMNNAME,MOD,DATATYPE,CODE,LEN,"DEC",NULLABLE,
             COLUMNPRIVILEGES,"DEFAULT","DEFAULTFUNCTION",DOMAINOWNER,DOMAINNAME,COLUMNNO,KEYCOLUMNNO,
             PHYSICAL_COLUMNNO,"DATE","TIME",ALTERDATE,ALTERTIME,TYPE,COMMENT
           FROM SYSDD.COLUMNS
           WHERE type IN('TABLE','RESULT','SYNONYM','VIEW','SYSTEM')
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.COLUMNS TO PUBLIC WITH GRANT OPTION')

#/ PTS 1105303
#/ PTS 1116602

    createReplaceView (session, 'DOMAIN.CONNECTPARAMETERS',
        """(SQLMODE,ISOLEVEL,TIMEOUT,SESSION)
        AS SELECT
             SQLMODE,ISOLEVEL,TIMEOUT,SESSION
           FROM SYSDD.CONNECTPARAMETERS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CONNECTPARAMETERS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.CONSTRAINTS',
        """(OWNER,TABLENAME,CONSTRAINTNAME,DEFINITION)
        AS SELECT
             OWNER,TABLENAME,CONSTRAINTNAME,DEFINITION
           FROM SYSDD.CONSTRAINTS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CONSTRAINTS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.DBPROCEDURES',
        """(OWNER,DBPROCNAME,PACKAGE,PARAMETER,
           CREATEDATE,CREATETIME,EXECUTION_KIND,"LANGUAGE",SQL_SUPPORT,WAIT_FOR_CHCKPT,
           REMOTE_LOCATION,DEFINITION,COMMENT)
        AS SELECT
             OWNER,DBPROCEDURE,PACKAGE,PARAMETER,
             "DATE","TIME","EXECUTION_KIND","LANGUAGE",SQL_SUPPORT,WAIT_FOR_CHKPT,
             REMOTE_LOCATION,DEFINITION,COMMENT
           FROM  SYSDD.DBPROCEDURES
           WHERE "TYPE" = 'DBPROC'
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.DBPROCEDURES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.DBFUNCTIONS',
        """(OWNER,DBFUNCNAME,PARAMETER,
           CREATEDATE,CREATETIME,SQL_SUPPORT,
           DEFINITION,COMMENT)
        AS SELECT
             OWNER,DBPROCEDURE,PARAMETER,
             "DATE","TIME",SQL_SUPPORT,
             DEFINITION,COMMENT
           FROM  SYSDD.DBPROCEDURES
           WHERE "TYPE" = 'DBFUNC'
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.DBFUNCTIONS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.DBPROCPARAMS',
        """(OWNER,DBPROCNAME,PARAMETERNAME,POS,"IN/OUT-TYPE",
           DATATYPE,CODETYPE,LEN,"DEC",CREATEDATE,CREATETIME)
        AS SELECT
             OWNER,DBPROCEDURE,PARAMETERNAME,PARAM_NO,"IN/OUT-TYPE",
             DATATYPE,CODE,LEN,"DEC","DATE","TIME"
           FROM SYSDD.DBPROCPARAMETERS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.DBPROCPARAMS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.DBPROCPARAMINFO',
        """AS SELECT *
        FROM SYSDD.DBPROCPARAMETERS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.DBPROCPARAMINFO TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.PACKAGES',
        """(OWNER,PACKAGE,
           CREATEDATE,CREATETIME,EXECUTION_KIND,SQL_SUPPORT,REMOTE_LOCATION,FILE,COMMENT)
        AS SELECT
             OWNER,PACKAGE,
             "DATE","TIME","TYPE",SQL_SUPPORT,REMOTE_LOCATION,FILE,COMMENT
           FROM  SYSDD.DBPROCEDURES
           WHERE PACKAGE IS NOT NULL AND DBPROCEDURE = PACKAGE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.PACKAGES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.DOMAINS',
        """(OWNER,DOMAINNAME,DATATYPE,CODETYPE,LEN,"DEC",
           "DEFAULT","DEFAULTFUNCTION",DEFINITION,CREATEDATE,CREATETIME,COMMENT)
        AS SELECT
             OWNER,DOMAINNAME,DATATYPE,CODE,LEN,"DEC",
             "DEFAULT","DEFAULTFUNCTION",DEFINITION,"DATE","TIME",COMMENT
           FROM SYSDD.DOMAINS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.DOMAINS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.DOMAINCONSTRAINTS',
        """(OWNER,DOMAINNAME,CONSTRAINTNAME,DEFINITION)
        AS SELECT
             OWNER,DOMAINNAME,CONSTRAINTNAME,DEFINITION
           FROM SYSDD.DOMAIN_CONSTRAINTS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.DOMAINCONSTRAINTS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.FOREIGNKEYS',
        """(OWNER,TABLENAME,FKEYNAME,RULE,CREATEDATE,CREATETIME)
        AS SELECT DISTINCT
             OWNER,TABLENAME,REFNAME,RULE,"DATE","TIME"
           FROM SYSDD.FOREIGN_KEYS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.FOREIGNKEYS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.FOREIGNKEYCOLUMNS',
        """(OWNER,TABLENAME,COLUMNNAME,FKEYNAME,
           REFOWNER,REFTABLENAME,REFCOLUMNNAME,
           RULE,CREATEDATE,CREATETIME,COMMENT)
        AS SELECT
             OWNER,TABLENAME,COLUMNNAME,REFNAME,
             REFOWNER,REFTABLENAME,REFCOLUMNNAME,
             RULE,"DATE","TIME",COMMENT
           FROM SYSDD.FOREIGN_KEYS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.FOREIGNKEYCOLUMNS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.INDEXES',
        """(OWNER,TABLENAME,INDEXNAME,
           TYPE,CREATEDATE,CREATETIME,INDEX_USED, DISABLED, COMMENT)
        AS SELECT
             OWNER,TABLENAME,INDEXNAME,
             TYPE,"DATE","TIME",INDEX_USED, DISABLED, COMMENT
           FROM SYSDD.INDEXES
           WHERE columnno = 1
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.INDEXES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.INDEXCOLUMNS',
        """(OWNER,TABLENAME,INDEXNAME,TYPE,
           COLUMNNAME,SORT,COLUMNNO,DATATYPE,LEN,
           CREATEDATE,CREATETIME,INDEX_USED, DISABLED, COMMENT)
        AS SELECT
             OWNER,TABLENAME,INDEXNAME,TYPE,
             COLUMNNAME,SORT,COLUMNNO,DATATYPE,LEN,
             "DATE","TIME",INDEX_USED, DISABLED, COMMENT
           FROM SYSDD.INDEXES
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.INDEXCOLUMNS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.MAPCHARSETS',
        """(MAPCHARSETNAME,CODE,INTERN,MAP_CODE,MAP_CHARACTER)
        AS SELECT
             MAPCHARSETNAME,CODE,INTERN,"MAP CODE","MAP CHARACTER"
           FROM SYSDD.MAPCHARSETS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.MAPCHARSETS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SESSION_ROLES',
        """("ROLE")
        AS SELECT SESSION_ROLES
        FROM SYSDD.SESSION_ROLES
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SESSION_ROLES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.ROLES',
        """(OWNER, ROLE, PASSWORD_REQUIRED, GRANTED, DEFAULTROLE, CREATEDATE, CREATETIME)
        AS SELECT OWNER, ROLE, "PASSWORD", GRANTED, DEFAULTROLE, "DATE", "TIME"
        FROM SYSDD.ROLES
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.ROLES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.ROLEPRIVILEGES',
        """(OWNER,TABLENAME,ROLE,GRANTEE,PRIVILEGES,GRANTOR,
        CREATEDATE,CREATETIME)
        AS SELECT OWNER, DECODE(TYPE,'ROLE',NULL,NAME1), DECODE(TYPE,'ROLE',NAME1,NULL)
        ,GRANTEE, PRIVILEGES, GRANTOR, "DATE","TIME"
        FROM SYSDD.PRIVILEGES
        WHERE TYPE = 'ROLE' OR GRANTEE IN (SELECT ROLE FROM SYSDD.ROLES)
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.ROLEPRIVILEGES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session,'DOMAIN.SCHEMAS',
         """(SCHEMA_NAME,SCHEMA_HANDLE,CREATEDATE,CREATETIME)
         AS SELECT
             SCHEMA,SCHEMA_HANDLE,"DATE","TIME"
         FROM SYSDD.SCHEMAS
         INTERNAL""");

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SCHEMAS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SEQUENCES',
        """(OWNER,SEQUENCE_NAME,MIN_VALUE,MAX_VALUE,INCREMENT_BY,CYCLE_FLAG,
           ORDER_FLAG,CACHE_SIZE,LAST_NUMBER,CREATEDATE,CREATETIME,COMMENT)
        AS SELECT
             OWNER,SEQUENCE_NAME,MIN_VALUE,MAX_VALUE,INCREMENT_BY,CYCLE_FLAG,
             ORDER_FLAG,CACHE_SIZE,LAST_NUMBER,"DATE","TIME",COMMENT
        FROM SYSDD.SEQUENCES
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SEQUENCES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYNONYMS',
        """(OWNER,SYNONYMNAME,PUBLIC,TABLEOWNER,TABLENAME,
           CREATEDATE,CREATETIME,COMMENT)
        AS SELECT
             SYNONYMOWNER,SYNONYMNAME,PUBLIC,OWNER,TABLENAME,
             "DATE","TIME",COMMENT
           FROM SYSDD.SYNONYMS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYNONYMS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.TABLES',
        """(OWNER,TABLENAME,PRIVILEGES,TYPE,TABLETYPE,CREATEDATE,CREATETIME,
           UPDSTATDATE,UPDSTATTIME,ALTERDATE,ALTERTIME,UNLOADED,
           SAMPLE_PERCENT,SAMPLE_ROWS,COMMENT,TABLEID,DYNAMIC,ARCHIVE)
        AS SELECT
             OWNER,TABLENAME,PRIVILEGES,TYPE,TABLETYPE,"DATE","TIME",
             UPDSTATDATE,UPDSTATTIME,ALTERDATE,ALTERTIME,
             UNLOADED,SAMPLE_PERCENT,SAMPLE_ROWS,
             COMMENT,OBJECTID,DYNAMIC,ARCHIVE
           FROM SYSDD.TABLES
           WHERE type IN('TABLE','RESULT','SYNONYM','VIEW','SYSTEM')
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.TABLES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.BWTABLES',
        """(OWNER,TABLENAME,FACT,DIMENSION,BWHIERARCHY)
        AS SELECT
             OWNER,TABLENAME,FACT,DIMENSION,BWHIERARCHY
           FROM SYSDD.TABLES
           WHERE type IN('TABLE','RESULT','SYNONYM','VIEW','SYSTEM')
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.BWTABLES TO PUBLIC WITH GRANT OPTION')

    # PTS 1116602

    createReplaceView (session, 'DOMAIN.TRIGGERS',
        """(OWNER,TABLENAME,TRIGGERNAME,"INSERT","UPDATE","DELETE",
           CREATEDATE,CREATETIME,DEFINITION,COMMENT)
        AS SELECT
             OWNER,TABLENAME,TRIGGERNAME,INSERT,UPDATE,DELETE,
             "DATE","TIME",DEFINITION,COMMENT
           FROM SYSDD.TRIGGERS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.TRIGGERS TO PUBLIC WITH GRANT OPTION')

#/ PTS 1114385

    createReplaceView (session, 'DOMAIN.USERS',
        """(OWNER,GROUPNAME,USERNAME,USERMODE,CONNECTMODE,
           MAXTIMEOUT,COSTWARNING,COSTLIMIT,DEFAULTCODE,CREATEDATE,CREATETIME,ALTERDATE,
           ALTERTIME,PWCREADATE,PWCREATIME,SERVERDB,SERVERNODE,USER_ID,COMMENT)
        AS SELECT
             OWNER,GROUPNAME,USERNAME,USERMODE,CONNECT,
             MAXTIMEOUT,COSTWARNING,COSTLIMIT,DEFAULTCODE,"DATE","TIME",ALTERDATE,
             ALTERTIME,PWCREATEDATE,PWCREATETIME,SERVERDB,SERVERNODE,USER_ID,COMMENT
           FROM SYSDD.USERS
        INTERNAL""")

    stopIfSqlNotOK (session, """GRANT SELECT (OWNER,GROUPNAME,USERNAME,USERMODE,CONNECTMODE,
              MAXTIMEOUT,COSTWARNING,COSTLIMIT,DEFAULTCODE,
              CREATEDATE,CREATETIME,ALTERDATE,ALTERTIME,PWCREADATE,
              PWCREATIME,SERVERDB,SERVERNODE,USER_ID,COMMENT)
              ON DOMAIN.USERS TO PUBLIC WITH GRANT OPTION""")

    createReplaceView (session, 'DOMAIN.CONNECTEDUSERS',
        """AS SELECT
             USERNAME,TERMID,SESSION,CATALOG_CACHE_SIZE
           FROM SYSDD.CONNECTED_USERS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.CONNECTEDUSERS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.VERSIONS',
        """AS SELECT *
           FROM SYSDD.VERSION
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.VERSIONS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.VIEWS',
        """(OWNER,VIEWNAME,PRIVILEGES,TYPE,CREATEDATE,CREATETIME,
           UPDSTATDATE,UPDSTATTIME,ALTERDATE,ALTERTIME,
           UNLOADED,COMMENT)
        AS SELECT
             OWNER,TABLENAME,PRIVILEGES,TYPE,"DATE","TIME",
             UPDSTATDATE,UPDSTATTIME,ALTERDATE,ALTERTIME,
             UNLOADED,COMMENT
           FROM SYSDD.TABLES
           WHERE tabletype = 'VIEW'
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.VIEWS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.VIEWDEFS',
        """(OWNER,VIEWNAME,LEN,DEFINITION)
        AS SELECT
             OWNER,TABLENAME,LEN,DEFINITION
           FROM SYSDD.VIEWS
           WHERE owner = USERGROUP
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.VIEWDEFS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.VIEWCOLUMNS',
        """(OWNER,VIEWNAME,VIEWCOLUMNNAME,
           TABLEOWNER,TABLENAME,COLUMNNAME,CREATEDATE,CREATETIME)
        AS SELECT
             OWNER,TABLENAME,COLUMNNAME,
             REFOWNER,REFTABLENAME,REFCOLUMNNAME,DATE,TIME
           FROM SYSDD.REFERENCED_COLUMNS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.VIEWCOLUMNS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.TABLEPRIVILEGES',
        """(OWNER,TABLENAME,
           GRANTOR,GRANTEE,PRIVILEGE,IS_GRANTABLE)
        AS SELECT
             OWNER,NAME1,
             GRANTOR,GRANTEE,
             DECODE(SUBSTR(PRIVILEGES,LENGTH(PRIVILEGES),1),'+',
                    SUBSTR(PRIVILEGES,1,LENGTH(PRIVILEGES) - 1),PRIVILEGES),
             DECODE(SUBSTR(PRIVILEGES,LENGTH(PRIVILEGES),1),'+','YES','NO')
           FROM SYSDD.NEW_PRIVILEGES
           WHERE NAME2 IS NULL
           AND TYPE NOT IN('SEQUENCE','DBPROC','ROLE')
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.TABLEPRIVILEGES TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.LOCKS',
        """AS SELECT
            SESSION,
            TRANSCOUNT,
            PROCESS,
            USERNAME,
            "DATE",
            "TIME",
            TERMID,
            LASTWRITE,
            LOCKMODE,
            LOCKSTATE,
            APPLPROCESS,
            APPLNODE,
            OWNER,
            TABLENAME,
            TABLEID,
            ROWIDLENGTH,
            ROWIDHEX,
            ROWID
           FROM SYSDBA.LOCKSTATISTICS
           WHERE REQMODE IS NULL AND LOCKMODE IS NOT NULL
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.LOCKS TO PUBLIC')

    createReplaceView (session, 'DOMAIN.LOCK_HOLDER',
        """AS SELECT
            SESSION,
            TRANSCOUNT,
            PROCESS,
            USERNAME,
            "DATE",
            "TIME",
            TERMID,
            LASTWRITE,
            LOCKMODE,
            LOCKSTATE,
            APPLPROCESS,
            APPLNODE,
            OWNER,
            TABLENAME,
            TABLEID,
            ROWIDLENGTH,
            ROWIDHEX,
            ROWID
           FROM SYSDBA.LOCKSTATISTICS
           WHERE REQMODE IS NULL AND LOCKMODE IS NOT NULL
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.LOCK_HOLDER TO PUBLIC')

    createReplaceView (session, 'DOMAIN.LOCK_REQUESTOR',
        """AS SELECT
            SESSION,
            TRANSCOUNT,
            PROCESS,
            USERNAME,
            "DATE",
            "TIME",
            TERMID,
            REQTIMEOUT,
            LASTWRITE,
            REQMODE,
            REQSTATE,
            APPLPROCESS,
            APPLNODE,
            OWNER,
            TABLENAME,
            TABLEID,
            ROWIDLENGTH,
            ROWIDHEX,
            ROWID
           FROM SYSDBA.LOCKSTATISTICS
           WHERE REQMODE IS NOT NULL AND LOCKMODE IS NULL
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.LOCK_REQUESTOR TO PUBLIC')

    createReplaceView (session, 'DOMAIN.LOCK_WAITS',
        """AS SELECT
             H.TABLENAME   TABLENAME,
             H.TABLEID     TABLEID,
             H.TERMID      H_TERMID,
             H.PROCESS     H_PROCESS,
             H.APPLPROCESS H_APPLPROCESS,
             H.APPLNODE    H_APPLNODE,
             H.ROWIDHEX    H_ROWIDHEX,
             H.ROWID       H_ROWID,
             H.LOCKMODE    H_LOCKMODE,
             H."DATE"      H_DATE,
             H."TIME"      H_TIME,
             EXPAND (NULL, 10) H_LOCKTIMEOUT,
             R.TERMID      R_TERMID,
             R.PROCESS     R_PROCESS,
             R.APPLPROCESS R_APPLPROCESS,
             R.APPLNODE    R_APPLNODE,
             R.ROWIDHEX    R_ROWIDHEX,
             R.ROWID       R_ROWID,
             R.REQMODE     R_REQMODE,
             R."DATE"      R_DATE,
             R."TIME"      R_TIME,
             R.REQTIMEOUT  R_REQTIMEOUT
           FROM DOMAIN.LOCK_REQUESTOR R, DOMAIN.LOCK_HOLDER H
           WHERE H.TABLEID = R.TABLEID
             AND (
                  H.ROWID = R.ROWID AND
                     (H.LOCKMODE = 'ROW_EXCLUSIVE' OR R.REQMODE = 'ROW_EXCLUSIVE')
                  OR
                  (H.LOCKMODE = 'ROW_EXCLUSIVE' AND R.REQMODE = 'TAB_SHARE')
                  OR
                  (H.LOCKMODE = 'TAB_SHARE' AND R.REQMODE = 'ROW_EXCLUSIVE')
                  OR
                  H.LOCKMODE = 'SYS_EXCLUSIVE'
                  OR
                  R.REQMODE = 'SYS_EXCLUSIVE'
                  OR
                  H.LOCKMODE = 'TAB_EXCLUSIVE'
                  OR
                  R.REQMODE = 'TAB_EXCLUSIVE'
                 )
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.LOCK_WAITS TO PUBLIC')

    createReplaceView (session, 'DOMAIN.SYSMON_BACKUPIOACCESS',
        """AS SELECT
           DEVICEID, DEVICENAME, BACKUPREADS, BACKUPWRITES,
           BACKUPPAGES, QUEUELEN, QUEUEMAX
           FROM SYSDD.SYSMON_BACKUPIOACC
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_BACKUPIOACCESS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_CONNECTION',
        """AS SELECT
           TASKINDEX, UKTID, APPLPID, PEERPID, TASKNAME,
           CONNECTSTATE, CONNECTTIME, REMOTEAPPLNODE
           FROM SYSDD.SYSMON_CONNECTION
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_CONNECTION TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_SPECIAL_THREAD',
        """AS SELECT
           OSPID, THREADNAME
           FROM SYSDD.SYSMON_SPECTHREAD
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_SPECIAL_THREAD TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_IOTHREAD',
        """AS SELECT
           OSPID, THREADNAME, VOLUMEID, VOLUMENAME, READS, WRITES,
           QUEUELEN, QUEUEMAX
           FROM SYSDD.SYSMON_IOTHREAD
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_IOTHREAD TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_IOACCESS',
        """AS SELECT
           DEVICEID, DEVICENAME, READS, READPAGES, WRITES, WRITEPAGES
           FROM SYSDD.SYSMON_IOACCESS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_IOACCESS TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_REGION',
        """AS SELECT
           REGID, REGIONNAME, OWNERDBPID, REQSTDBPID,
           ACCESSES, TEST_AND_SET, WAITS, COLLISIONS,
           COLLISION_RATE, LOCKED
           FROM SYSDD.SYSMON_REGION
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_REGION TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_STORAGE',
        """AS SELECT
           DESC, VAL, VDESC
           FROM SYSDD.SYSMON_STORAGE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_STORAGE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_UKTHREAD',
        """AS SELECT
           OSPID, THREADNAME, DISPATCHCNT, COMMANDCNT,
           TASKS_ACTIVE, TASKS_TOTAL, TASKCLUSTER
           FROM SYSDD.SYSMON_UKTHREAD
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_UKTHREAD TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_TASK',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, OMSCALLACTIVE, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_TASK
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_TASK TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_ACTIVE_TASK',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_ACTIVE_TASK
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_ACTIVE_TASK TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_RUNNABLE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_RUNNABLE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_RUNNABLE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_US',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_US
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_US TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_US_ACTIVE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_US_ACTIVE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_US_ACTIVE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_US_RUNNABLE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_US_RUNNABLE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_US_RUNNABLE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_SV',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_SV
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_SV TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_SV_ACTIVE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_SV_ACTIVE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_SV_ACTIVE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_SV_RUNNABLE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_SV_RUNNABLE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_SV_RUNNABLE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_DW',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_DW
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_DW TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_DW_ACTIVE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_DW_ACTIVE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_DW_ACTIVE TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_DW_RUNNABLE',
        """AS SELECT
           DBPID, OSPID, TASKTYPE, APPID, STATEDESC,
           CANCEL_FLAG, SPECIAL_FLAG, TIMEOUT, REGID,
           WAITING4TASK, WAITING4ROOT, EXTENDEDTASKSTATE
           FROM SYSDD.SYSMON_DW_RUNNABLE
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_DW_RUNNABLE TO PUBLIC WITH GRANT OPTION')

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = 'INSTANCE_TYPE'
        AND "VALUE" = 'LVC'""")

    if rc == 0:

        createReplaceView (session, 'DOMAIN.SYSMON_TASK_DETAIL',
            """AS SELECT
               DBPID, TASKNAME, STATEDESC, APPL_NODEID, APPL_PROCESS,
               DISPATCHCNT, COMMANDCNT, PRIOCNT,
               TASKSELFSUSPCNT, REGIONACCESSCNT,
               SIOREADCNT, SIOREADPAGES, SIOREADAVGABSTIME, SIOREADTOTABSTIME,
               SIOWRITECNT, SIOWRITEPAGES, SIOWRITEAVGABSTIME, SIOWRITETOTABSTIME,
               IOREADCNT, IOREADPAGES, IOREADAVGRELTIME, IOREADTOTRELTIME,
               IOREADAVGABSTIME, IOREADTOTABSTIME,
               IOWRITECNT, IOWRITEPAGES, IOWRITEAVGRELTIME, IOWRITETOTRELTIME,
               IOWRITEAVGABSTIME, IOWRITETOTABSTIME, BKPREADCNT,
               BKPREADPAGES, BKPREADAVGRELTIME, BKPREADTOTRELTIME,
               BKPREADAVGABSTIME, BKPREADTOTABSTIME,
               BKPWRITECNT, BKPWRITEPAGES, BKPWRITEAVGRELTIME, BKPWRITETOTRELTIME,
               BKPWRITEAVGABSTIME, BKPWRITETOTABSTIME,
               VSUSPENDCNT, VSUSPENDAVGRELTIME, VSUSPENDTOTRELTIME,
               VSUSPENDAVGABSTIME, VSUSPENDTOTABSTIME,
               VWAITCNT, VWAITAVGRELTIME, VWAITTOTRELTIME,
               VWAITAVGABSTIME, VWAITTOTABSTIME,
               VSLEEPCNT, VSLEEPAVGRELTIME, VSLEEPTOTRELTIME,
               VSLEEPAVGABSTIME, VSLEEPTOTABSTIME,
               CMDCNT, AVGCMDEXECUTETIME, TOTCMDEXECUTETIME,
               AVGCMDWAITRELTIME, TOTCMDWAITRELTIME,
               AVGCMDWAITABSTIME, TOTCMDWAITABSTIME,
               OMSCOMROUTINENAME, OMSCALLBACKCOUNT, OMSCALLBACKMETHOD
               FROM SYSDD.SYSMON_TASK_DETAIL
            INTERNAL""")

    else:
        createReplaceView (session, 'DOMAIN.SYSMON_TASK_DETAIL',
            """AS SELECT
               DBPID, TASKNAME, STATEDESC, APPL_NODEID, APPL_PROCESS,
               DISPATCHCNT, COMMANDCNT, PRIOCNT,
               TASKSELFSUSPCNT, REGIONACCESSCNT,
               SIOREADCNT, SIOREADPAGES, SIOREADAVGABSTIME, SIOREADTOTABSTIME,
               SIOWRITECNT, SIOWRITEPAGES, SIOWRITEAVGABSTIME, SIOWRITETOTABSTIME,
               IOREADCNT, IOREADPAGES, IOREADAVGRELTIME, IOREADTOTRELTIME,
               IOREADAVGABSTIME, IOREADTOTABSTIME,
               IOWRITECNT, IOWRITEPAGES, IOWRITEAVGRELTIME, IOWRITETOTRELTIME,
               IOWRITEAVGABSTIME, IOWRITETOTABSTIME, BKPREADCNT,
               BKPREADPAGES, BKPREADAVGRELTIME, BKPREADTOTRELTIME,
               BKPREADAVGABSTIME, BKPREADTOTABSTIME,
               BKPWRITECNT, BKPWRITEPAGES, BKPWRITEAVGRELTIME, BKPWRITETOTRELTIME,
               BKPWRITEAVGABSTIME, BKPWRITETOTABSTIME,
               VSUSPENDCNT, VSUSPENDAVGRELTIME, VSUSPENDTOTRELTIME,
               VSUSPENDAVGABSTIME, VSUSPENDTOTABSTIME,
               VWAITCNT, VWAITAVGRELTIME, VWAITTOTRELTIME,
               VWAITAVGABSTIME, VWAITTOTABSTIME,
               VSLEEPCNT, VSLEEPAVGRELTIME, VSLEEPTOTRELTIME,
               VSLEEPAVGABSTIME, VSLEEPTOTABSTIME,
               CMDCNT, AVGCMDEXECUTETIME, TOTCMDEXECUTETIME,
               AVGCMDWAITRELTIME, TOTCMDWAITRELTIME,
               AVGCMDWAITABSTIME, TOTCMDWAITABSTIME
               FROM SYSDD.SYSMON_TASK_DETAIL
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_TASK_DETAIL TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.SYSMON_TOTALCOUNT',
        """AS SELECT
           DISPATCHCNT, COMMANDCNT,
           VWAITCNT, VSUSPENDCNT, VSLEEPCNT,
           PRIOCNT, USERTASKREADCNT, USERTASKWRITECNT,
           TASKIOCNT, IOCNT,
           REGIONACCESSCNT, REGIONCOLLCNT, REGIONWAITCNT,
           VBEGEXCLTASCOLLCNT, VENDEXCLTASCOLLCNT,
           TASKSELFSUSPCNT
           FROM SYSDD.SYSMON_TOTALCOUNT
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.SYSMON_TOTALCOUNT TO PUBLIC WITH GRANT OPTION')

    createReplaceView (session, 'DOMAIN.PARSINFOS',
        """AS SELECT
           SYSINFOKEY, KEY_SEQ, NAME1, NUMERIC_VALUE,
           TABLETYPE, SIZE
           FROM SYSDD.PARSINFOS
        INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON DOMAIN.PARSINFOS TO PUBLIC WITH GRANT OPTION')

    rc = sqlRC (session, 'COMMIT WORK')
    loaderCmd (session, 'INSTALLATION OFF')




