#
# =====================================================
# @(#) WebDAV                     7.4        2002-11-11
# =====================================================
# Changes in  7.4:
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def install (session,options):
    """Installing tables for WebDAV
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    requireSysdba (session)

    #----------------------------------------------------------------------------
    # Table WEBDAV_INODE
    #----------------------------------------------------------------------------

    if not existsTable (session, "WEBDAV_INODE"):
        stopIfSqlNotOK (session, """
            Create Table WEBDAV_INODE
            (
                PID              CHAR(24)		BYTE        ,
                CID              CHAR(24)		BYTE        ,
                NAME             SYSWEBDAV_NAME             ,
                STATE			 FIXED(2)		DEFAULT 0	,
                COMPRESSEDLENGTH FIXED(10)		DEFAULT 0   ,

                PRIMARY KEY (PID, NAME)                     ,

                CONSTRAINT WEBDAV_INODE_X UNIQUE (CID)
            ) INTERNAL""")

    #----------------------------------------------------------------------------
    # Table WEBDAV_CONTAINER
    #----------------------------------------------------------------------------

    if not existsTable (session, "WEBDAV_CONTAINER"):
        stopIfSqlNotOK (session, """
            CREATE TABLE WEBDAV_CONTAINER
            (
                CID				CHAR(24)   BYTE,
                SHORT_CONTENT	CHAR(8000) BYTE,
                CONTENT			LONG       BYTE,

                PRIMARY KEY (CID)
            ) INTERNAL""")

    #----------------------------------------------------------------------------
    # Table WEBDAV_NAME_SPACE
    #----------------------------------------------------------------------------

    if not existsTable (session, "WEBDAV_NAME_SPACE"):
        stopIfSqlNotOK (session, """
            CREATE TABLE WEBDAV_NAME_SPACE
            (
                ID         CHAR(24)    BYTE    ,
                NAME_SPACE SYSWEBDAV_NAME_SPACE,

                PRIMARY KEY (NAME_SPACE),
                CONSTRAINT WEBDAV_NAME_SPACE_X UNIQUE (ID)
            ) INTERNAL""")

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_NAME_SPACE SET
                ID = X'000000000000000000000000000000000000000000000001',
                NAME_SPACE = 'DAV:'
        """)

    #----------------------------------------------------------------------------
    # Table WEBDAV_PROPERTY_MANAGEMENT
    #----------------------------------------------------------------------------

    if not existsTable (session, "WEBDAV_PROPERTY_MANAGEMENT"):
        stopIfSqlNotOK (session, """
            CREATE TABLE WEBDAV_PROPERTY_MANAGEMENT
            (
               ID                CHAR(24)   BYTE                ,
               NAME_SPACE_ID     CHAR(24)   BYTE                ,
               NAME_PREFIX       SYSWEBDAV_PROPERTY_NAME_PREFIX ,
               NAME              SYSWEBDAV_PROPERTY_NAME        ,

               PRIMARY KEY (NAME_SPACE_ID, NAME_PREFIX)
            ) INTERNAL""")

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000001',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'displayname'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000002',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'resourcetype'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000003',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'getcontenttype'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000004',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'getcontentlength'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000005',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'getlastmodified'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000006',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'lockdiscovery'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000006',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'lockid'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000007',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'lockowner'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000008',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'locktype'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'000000000000000000000000000000000000000000000009',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'lockscope'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'00000000000000000000000000000000000000000000000A',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'locktimeout'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'00000000000000000000000000000000000000000000000B',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'lockdepth'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'00000000000000000000000000000000000000000000000C',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'supportedlock'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'00000000000000000000000000000000000000000000000D',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'docclassid'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY_MANAGEMENT SET
                ID = X'00000000000000000000000000000000000000000000000E',
                NAME_SPACE_ID = X'000000000000000000000000000000000000000000000001',
                NAME_PREFIX = 'parsestate'
        """)

        stopIfSqlNotOK (session, """
            Insert into WEBDAV_PROPERTY_MANAGEMENT Set
                Id = X'00000000000000000000000000000000000000000000000F',
                Name_Space_Id = X'000000000000000000000000000000000000000000000001',
                Name_Prefix = 'originallocation'
        """)

    #----------------------------------------------------------------------------
    # Table WEBDAV_PROPERTY
    #----------------------------------------------------------------------------

    if not existsTable (session, "WEBDAV_PROPERTY"):
        stopIfSqlNotOK (session, """
            CREATE TABLE WEBDAV_PROPERTY
            (
               CID                  CHAR(24)  BYTE                 ,

               PROPERTY_ID          CHAR(24)  BYTE                 ,
               PROPERTY_SHORT_VALUE SYSWEBDAV_PROPERTY_SHORT_VALUE ,
               PROPERTY_LONG_VALUE  LONG      BYTE
            ) INTERNAL""")

        stopIfSqlNotOK (session, """
            CREATE INDEX WEBDAV_PROPERTY_X1 ON WEBDAV_PROPERTY (PROPERTY_ID, CID)
        """)

        stopIfSqlNotOK (session, """
            CREATE INDEX WEBDAV_PROPERTY_X2 ON WEBDAV_PROPERTY (CID DESC)
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000000',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_SHORT_VALUE = '/'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000000',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000002',
                PROPERTY_SHORT_VALUE = 'collection'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000000',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000003',
                PROPERTY_SHORT_VALUE = 'sapdbwww/directory'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000000',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000004',
                PROPERTY_SHORT_VALUE = '0'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000000',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000005',
                PROPERTY_SHORT_VALUE = TIMESTAMP
        """)

    #----------------------------------------------------------------------------
    # Folder Deleted Items
    #----------------------------------------------------------------------------

    if not sqlOK(session, """
        SELECT * FROM WEBDAV_INODE WHERE
        PId = X'000000000000000000000000000000000000000000000000' AND
        CId = X'000000000000000000000000000000000000000000000001' AND
        Name = 'Deleted Items'
    """):

        stopIfSqlNotOK (session, """
            Insert into WEBDAV_INODE Set
                PId = X'000000000000000000000000000000000000000000000000',
                CId = X'000000000000000000000000000000000000000000000001',
                Name = 'Deleted Items',
                State = 0,
                CompressedLength = 0
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_SHORT_VALUE = 'Deleted Items'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000002',
                PROPERTY_SHORT_VALUE = 'collection'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000003',
                PROPERTY_SHORT_VALUE = 'sapdbwww/directory'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000004',
                PROPERTY_SHORT_VALUE = '0'
        """)

        stopIfSqlNotOK (session, """
            INSERT INTO WEBDAV_PROPERTY SET
                CID = X'000000000000000000000000000000000000000000000001',
                PROPERTY_ID = X'000000000000000000000000000000000000000000000005',
                PROPERTY_SHORT_VALUE = TIMESTAMP
        """)

    #----------------------------------------------------------------------------
    # Commit the data definitions
    #----------------------------------------------------------------------------

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


