#
# =====================================================
# @(#) WA                        7.4        2000-10-13
# =====================================================
# Created in  7.4:
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def install (session,options):
    """Installing tables for WebAgent
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    #ADIS #1001953/1002033
    requireSysdba (session)

    #----------------------------------------------------------------------------
    # Create tables for database filesystem
    #----------------------------------------------------------------------------

    #----------------------------------------------------------------------------
    # Create table container
    #----------------------------------------------------------------------------
    if not existsTable (session, "WA_CONTAINER"):
        stopIfSqlNotOK (session, """
            CREATE TABLE WA_CONTAINER
            (
             ViewOwner              SYSID,
             ContainerId            CHAR (8) BYTE NOT NULL DEFAULT STAMP,
             Inode                  CHAR (8) BYTE NOT NULL,
             Data                   LONG BYTE,
             Size                   INT,
             Compressed             CHAR(1) ASCII,
             PRIMARY KEY (ContainerId),
             CONSTRAINT WA_CONTAINER_INDEX UNIQUE (Inode)
            ) INTERNAL""")
    else:
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE WA_CONTAINER MODIFY (ViewOwner SYSMSGTEXT)')

    #----------------------------------------------------------------------------
    # Create table inode
    #----------------------------------------------------------------------------
    if not existsTable (session, "WA_INODE"):
        stopIfSqlNotOK (session, """
         CREATE TABLE WA_INODE
          (
             ViewOwner              SYSID,
             PartitionId            INT,
             InodeId                CHAR (8) BYTE DEFAULT STAMP,
             ParentDirectory        CHAR (8) BYTE,
             Name                   CHAR(245)       NOT NULL,
             Type                   CHAR(4)  ASCII,
             Protection             CHAR(9)  ASCII,
             Owner                  CHAR(16),
             UGroup                 CHAR(16),
             CreationDate           DATE,
             CreationTime           TIME,
             ModificationDate       DATE,
             ModificationTime       TIME,
             Container              CHAR (8) BYTE,
             LinkInode              CHAR (8) BYTE,
             Size                   INT,
             PRIMARY KEY (PartitionId,InodeId),
             CONSTRAINT WA_INODE_INDEX_1 UNIQUE (ViewOwner,ParentDirectory, Name),
             CONSTRAINT WA_INODE_INDEX_2 UNIQUE (Container)
            ) INTERNAL""")
    else:
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE WA_INODE MODIFY (ViewOwner SYSMSGTEXT)')

    #----------------------------------------------------------------------------
    # alter dbfs tables
    #----------------------------------------------------------------------------
    # This kind of foreign key definition is restricted in SAP DB 7.4
    # The referential delete on index is not implemented (Thomas Anhaus)
    # WebAgent tries to delete all referential depending data entries
    #stopIfSqlNotOK (session, "ALTER TABLE WA_CONTAINER FOREIGN KEY (Inode) REFERENCES WA_INODE (InodeId)  ON DELETE CASCADE")
    #stopIfSqlNotOK (session, "ALTER TABLE WA_INODE FOREIGN KEY (LinkInode) REFERENCES WA_INODE (InodeId)  ON DELETE CASCADE")

    stopIfSqlNotOK (session, "COMMENT ON TABLE WA_INODE IS 'Inode describes a UNIX-like directory  structure.'")


    #----------------------------------------------------------------------------
    # Create the view of dbfs container
    #----------------------------------------------------------------------------
    dropView (session, "WA_MY_CONTAINER")
    stopIfSqlNotOK (session, """
            CREATE VIEW WA_MY_CONTAINER AS
            SELECT  *
            FROM    WA_CONTAINER
            WHERE   VIEWOWNER = USERGROUP
        WITH CHECK OPTION INTERNAL""")

    #----------------------------------------------------------------------------
    # Create the view of dbfs inode
    #----------------------------------------------------------------------------
    dropView (session, "WA_MY_INODE")
    stopIfSqlNotOK (session, """
            CREATE VIEW WA_MY_INODE AS
            SELECT  *
            FROM    WA_INODE
            WHERE   VIEWOWNER = USERGROUP
        WITH CHECK OPTION INTERNAL""")
    #----------------------------------------------------------------------------
    # Grant for the view WA_MY_CONTAINER
    #----------------------------------------------------------------------------
    stopIfSqlNotOK (session, """
            GRANT   SELECT, UPDATE, DELETE, INSERT
            ON      WA_MY_CONTAINER
            TO      PUBLIC""")

    #----------------------------------------------------------------------------
    # Grant for the view WA_MY_INODE
    #----------------------------------------------------------------------------
    stopIfSqlNotOK (session, """
            GRANT   SELECT, UPDATE, DELETE, INSERT
            ON      WA_MY_INODE
            TO      PUBLIC""")

    #----------------------------------------------------------------------------
    # Commit the data definitions
    #----------------------------------------------------------------------------

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


