#SAY --- Installing SYSINFO catalog views ...
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def createSysinfoSynonym (session, view):
    stopIfSqlNotOK (session, 'grant select on sysinfo.' + view
        + ' to public')
    stopIfSqlNotErr (session, -4007, 'drop public synonym ' + view)
    stopIfSqlNotOK (session, 'create public synonym ' + view
        + ' for sysinfo.' + view + ' internal')

def install (session,options):
    """Installing SYSINFO tables
    """
    switchToDefaultUser (session, options)

    stopIfSqlNotErr (session, -6006,
        'CREATE USER SYSINFO PASSWORD %s RESOURCE' % options.dompwd)

    sqlOK (session, "COMMIT")

    loaderCmd (session, 'USE USER SYSINFO %s' % options.dompwd)

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

#   those 15 SYSINFO-views known in 7.4.4.2 have to be dropped before, PTS 1122989
    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.ACTIVECONFIGURATION')
    createReplaceView (session, 'SYSINFO.ACTIVECONFIGURATION',
        """AS SELECT *
           FROM SYSDD.ACTIVECONFIGURATION
        INTERNAL""")

    createSysinfoSynonym (session, 'ACTIVECONFIGURATION')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.CACHESTATISTICS')
    createReplaceView (session, 'SYSINFO.CACHESTATISTICS',
        """AS SELECT *
           FROM SYSDD.CACHESTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'CACHESTATISTICS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.COMMANDCACHESTATISTICS')
    createReplaceView (session, 'SYSINFO.COMMANDCACHESTATISTICS ',
        """AS SELECT *
           FROM SYSDD.COMMANDCACHESTATISTICS
           WHERE USER IN(SELECT USERNAME
                         FROM SYSDD.USERS
                         WHERE USERNAME = USERGROUP
                         AND USERMODE IN('DBA','SYSDBA','ADMIN'))
        INTERNAL""")

    createSysinfoSynonym (session, 'COMMANDCACHESTATISTICS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.COMMANDSTATISTICS')
    createReplaceView (session, 'SYSINFO.COMMANDSTATISTICS',
        """AS SELECT *
           FROM SYSDD.COMMANDSTATISTICS
           WHERE USER IN(SELECT USERNAME
                         FROM SYSDD.USERS
                         WHERE USERNAME = USERGROUP
                         AND USERMODE IN('DBA','SYSDBA','ADMIN'))
        INTERNAL""")

    createSysinfoSynonym (session, 'COMMANDSTATISTICS')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.DATAVOLUMES')
    createReplaceView (session, 'SYSINFO.DATAVOLUMES',
        """AS SELECT *
           FROM SYSDD.DATAVOLUMES
        INTERNAL""")

    createSysinfoSynonym (session, 'DATAVOLUMES')

    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.DATASTATISTICS')
    createReplaceView (session, 'SYSINFO.DATASTATISTICS',
        """AS SELECT *
           FROM SYSDD.DATASTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'DATASTATISTICS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.HOTSTANDBYCOMPONENT')
    createReplaceView (session, 'SYSINFO.HOTSTANDBYCOMPONENT',
        """AS SELECT *
           FROM SYSDD.HOTSTANDBYCOMPONENT
        INTERNAL""")

    createSysinfoSynonym (session, 'HOTSTANDBYCOMPONENT')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.HOTSTANDBYGROUP')
    createReplaceView (session, 'SYSINFO.HOTSTANDBYGROUP',
        """AS SELECT *
           FROM SYSDD.HOTSTANDBYGROUP
        INTERNAL""")

    createSysinfoSynonym (session, 'HOTSTANDBYGROUP')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.INSTANCE')
    createReplaceView (session, 'SYSINFO.INSTANCE ',
        """AS SELECT *
           FROM SYSDD.INSTANCE
        INTERNAL""")

    createSysinfoSynonym (session, 'INSTANCE')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.LOGVOLUMES')
    createReplaceView (session, 'SYSINFO.LOGVOLUMES',
        """AS SELECT *
           FROM SYSDD.LOGVOLUMES
        INTERNAL""")

    createSysinfoSynonym (session, 'LOGVOLUMES')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.MEMORYALLOCATORSTATISTICS')
    createReplaceView (session, 'SYSINFO.MEMORYALLOCATORSTATISTICS',
        """AS SELECT *
           FROM SYSDD.MEMORYALLOCATORSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'MEMORYALLOCATORSTATISTICS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.MEMORYHOLDERS')
    createReplaceView (session, 'SYSINFO.MEMORYHOLDERS',
        """AS SELECT *
           FROM SYSDD.MEMORYHOLDERS
        INTERNAL""")

    createSysinfoSynonym (session, 'MEMORYHOLDERS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.OMSLOCKS')
    createReplaceView (session, 'SYSINFO.OMSLOCKS',
        """AS SELECT *
           FROM SYSDD.OMSLOCKS
        INTERNAL""")

    createSysinfoSynonym (session, 'OMSLOCKS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.OPTIMIZERINFORMATION')
    createReplaceView (session, 'SYSINFO.OPTIMIZERINFORMATION',
        """AS SELECT *
           FROM SYSDD.OPTIMIZERINFORMATION
        INTERNAL""")

    createSysinfoSynonym (session, 'OPTIMIZERINFORMATION')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.SNAPSHOTS')
    createReplaceView (session, 'SYSINFO.SNAPSHOTS',
        """AS SELECT *
           FROM SYSDD.SNAPSHOTS
        INTERNAL""")

    createSysinfoSynonym (session, 'SNAPSHOTS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.SPINLOCKSTATISTICS')
    createReplaceView (session, 'SYSINFO.SPINLOCKSTATISTICS',
        """AS SELECT *
           FROM SYSDD.SPINLOCKSTATISTICS
        INTERNAL""")

    createSysinfoSynonym (session, 'SPINLOCKSTATISTICS')


    stopIfSqlNotErr (session, -4004, 'DROP VIEW SYSINFO.VERSION')
    createReplaceView (session, 'SYSINFO.VERSION',
        """AS SELECT *
           FROM SYSDD.VERSION_NEW
        INTERNAL""")

    createSysinfoSynonym (session, 'VERSION')


    rc = sqlRC (session, 'COMMIT WORK')
    loaderCmd (session, 'INSTALLATION OFF')

    switchToDefaultUser (session, options)
