#
# =====================================================
# @(#) SYSDBACOM                  7.4        2003-05-12
# =====================================================
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

from installib import *

def install (session,options):
    """Installing comments for SYSDBA tables
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')


    # Table sysdba.dbparameters

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.DBPARAMETERS IS 'Parameters that were defined for the the database instance by using the Database Manager tool'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DBPARAMETERS.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.DBPARAMETERS.VALUE IS 'Value'""")


    # Table sysdba.indexstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.INDEXSTATISTICS IS 'Information about the structure and size of indexes'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.INDEXNAME IS 'Name of index (NULL for unknown indexes)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.COLUMNNAME IS 'Name of an inverted column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.DESCRIPTION IS 'Description of how to interpret following columns'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.CHAR_VALUE IS 'Alphanumeric value'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.INDEXSTATISTICS.NUMERIC_VALUE IS 'Numeric value'""")

    # Table sysdba.lockliststatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.LOCKLISTSTATISTICS IS 'Information about the used space in the lock list'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.LOCKLISTSTATISTICS.DESCRIPTION IS 'Description of how to interpret the VALUE column'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.LOCKLISTSTATISTICS.VALUE IS 'Value'""")

    # Table sysdba.optimizerstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.OPTIMIZERSTATISTICS IS 'Stored statistics in the database catalog'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.OWNER IS 'Owner of a table for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.TABLENAME IS 'Name of a table for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.INDEXNAME IS 'Name of an index for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.COLUMNNAME IS 'Name of a column for which statistics exist'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.DISTINCTVALUES IS 'Number of different values if the current row describes a column or an index with one column; otherwise the number of rows in a table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.OPTIMIZERSTATISTICS.PAGECOUNT IS 'Number of pages used by an index if the current row describes an index; number of pages of a base table if the current row describes a table; otherwise NULL'""")

    # Table sysdba.serverdbstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.SERVERDBSTATISTICS IS 'Information about the used space in the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.SERVERDBSIZE IS 'Size of the database instance in pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.MAXDATAPAGENO IS 'Highest page number of the database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.MAXPERM IS 'Number of pages of the database instance that can be used for non-temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.MAXUSEDPAGES IS 'Maximum number of used pages for a synchronization point (restart or savepoint)'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDPERM IS 'Number of pages of the database instance that are used for non-temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUSEDPERM IS 'Percentage of pages for non-temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDTMP IS 'Number of pages of the database instance that are used for temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUSEDTMP IS 'Percentage of pages for temporary objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.UNUSED IS 'Number of unused pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUNUSED IS 'Percentage of unused pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.UPDATEDPERM IS 'Number of changed pages for permanent objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.SERVERDBFULL IS '(YES|NO) Maximum fill level of the datase instance has been reached'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDBLOCKS IS 'Number of blocks on data volumes that are used by pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGSIZE IS 'Size of the log range in pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.USEDLOG IS 'Number of used log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTUSEDLOG IS 'Percentage of used log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGNOTSAVED IS 'Number of unsaved log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.PCTLOGNOTSAVED IS 'Percentage of unsaved log pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGSINCEBACKUP IS 'Number of written log pages since the last complete or incremental data backup'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.LOGSEGMENTSIZE IS 'Size of a log segment in pages'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.SERVERDBSTATISTICS.SAVEPOINTS IS 'Number of executed savepoints'""")

    # Table sysdba.tablestatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.TABLESTATISTICS IS 'Information about the structure and sizes of base tables'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.OWNER IS 'Name of table owner'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.TABLENAME IS 'Name of table'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.DESCRIPTION IS 'Description of how to interpret following columns'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.CHAR_VALUE IS 'Alphanumeric value'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TABLESTATISTICS.NUMERIC_VALUE IS 'Numeric value'""")

    # Table sysdba.transactions

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.TRANSACTIONS IS 'Information about active transactions of of a database instance'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.SESSION IS 'ID of the database session'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.TRANSCOUNT IS 'Transaction ID'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.SUB_TRANS IS 'Number of the current subtransaction'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.WRITE_TRANS IS 'ID of the current write transaction if the transaction has made changes'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.PROCESS IS 'ID of the user process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.CONNECTDATE IS 'Date when the session started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.CONNECTTIME IS 'Time when the session started'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.TERMID IS 'Terminal ID'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.REQTIMEOUT IS 'Remaining time until REQUEST_TIMEOUT in seconds'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.LASTWRITE IS 'Time elapsed since the last write request in timeout intervals'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.LOCKMODE IS 'Type of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.LOCKSTATE IS 'Status of lock'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.REQMODE IS 'Type of lock request'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.REQSTATE IS 'Status of lock request'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.CONSISTENTVIEW IS 'For future use'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.APPLPROCESS IS 'ID of the application process'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.TRANSACTIONS.APPLNODEID IS 'ID of the client host of the application process'""")

    # Table sysdba.userstatistics

    stopIfSqlNotOK (session, """COMMENT ON TABLE SYSDBA.USERSTATISTICS IS 'Information about the resource consumption of users'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.USERNAME IS 'Name of user'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.USERMODE IS 'User class'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.PERMCOUNT IS 'Pages currently used for permanent objects'""")

    stopIfSqlNotOK (session, """COMMENT ON COLUMN SYSDBA.USERSTATISTICS.TEMPCOUNT IS 'Pages currently used for temporary objects'""")

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)

