#
# =====================================================
# @(#) PRECOM                    7.2        1999-07-29
# =====================================================
# Changes in  7.2:
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def install (session,options):
    """Installing precompiler tables
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    if sqlOK (session, "EXISTS TABLE SYSPROFIL"):
        stopIfSqlNotOK (session, "RENAME TABLE SYSPROFIL TO SYSPROFILE")

    if sqlOK (session, "EXISTS TABLE SYSPROFILE"):
        stopIfSqlNotOK (session, "DROP TABLE SYSPROFILE")

    stopIfSqlNotOK (session, """
        CREATE TABLE SYSPROFILE
       (
        USERNAME SYSID,
        PROGNAME SYSID,
        MODNAME  SYSID,
        LANGUAGE CHAR(12),
        LINENO   FIXED(7),
        PARSEID  CHAR(12)     BYTE,
        RUNDATE  DATE,
        RUNCOUNT FIXED(10),
        SECONDS  FIXED(12,3),
        STMBEGIN CHAR(1600),
        CONSTRAINT SYSPROFILE_PK
          PRIMARY KEY(USERNAME,PROGNAME,MODNAME,LANGUAGE,LINENO,PARSEID)
       )
       INTERNAL
       """)

    stopIfSqlNotOK (session, "GRANT ALL ON TABLE SYSPROFILE TO PUBLIC")

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)


