#
# =====================================================
# @(#) ODBC                    7.3.0.02       2000-11-17
# =====================================================
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


from installib import *

def install (session,options):
    """Installing ODBC and JDBC tables
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    # ********************************
    #  Table SYSODBCTYPES
    # ********************************

    dropTable (session, "SYSODBCTYPES")

    stopIfSqlNotOK (session, """
CREATE TABLE SYSODBCTYPES
    (
      "TYPE_NAME"           VARCHAR(18) ASCII NOT NULL,
      "DATA_TYPE"           SMALLINT NOT NULL,
      "PRECISION"           INTEGER,
      "LITERAL_PREFIX"      VARCHAR(3) ASCII,
      "LITERAL_SUFFIX"      VARCHAR(3) ASCII,
      "CREATE_PARAMS"       VARCHAR(128) ASCII,
      "NULLABLE"            SMALLINT NOT NULL,
      "CASE_SENSITIVE"      SMALLINT NOT NULL,
      "SEARCHABLE"          SMALLINT NOT NULL,
      "UNSIGNED_ATTRIBUTE"  SMALLINT,
      "MONEY"               SMALLINT NOT NULL,
      "AUTO_INCREMENT"      SMALLINT,
      "LOCAL_TYPE_NAME"     VARCHAR(18) ASCII,
      "MINIMUM_SCALE"       SMALLINT,
      "MAXIMUM_SCALE"       SMALLINT,
      "SQL_DATA_TYPE"       SMALLINT NOT NULL,
      "SQL_DATETIME_SUB"    SMALLINT,
      "NUM_PREC_RADIX"      INTEGER,
      "INTERVAL_PRECISION"  SMALLINT,
      "REMARKS"             VARCHAR(254) ASCII
    )
INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCTYPES TO PUBLIC')

    dataLoad (session, """
DATALOAD TABLE SYSODBCTYPES
"TYPE_NAME"           1
"DATA_TYPE"           2
"PRECISION"           3 DEFAULT NULL
"LITERAL_PREFIX"      4 DEFAULT NULL
"LITERAL_SUFFIX"      5 DEFAULT NULL
"CREATE_PARAMS"       6 DEFAULT NULL
"NULLABLE"            7
"CASE_SENSITIVE"      8
"SEARCHABLE"          9
"UNSIGNED_ATTRIBUTE" 10 DEFAULT NULL
"MONEY"              11
"AUTO_INCREMENT"     12 DEFAULT NULL
"LOCAL_TYPE_NAME"    13 DEFAULT NULL
"MINIMUM_SCALE"      14 DEFAULT NULL
"MAXIMUM_SCALE"      15 DEFAULT NULL
"SQL_DATA_TYPE"      16
"SQL_DATETIME_SUB"   17 DEFAULT NULL
"NUM_PREC_RADIX"     18 DEFAULT NULL
"INTERVAL_PRECISION" 19 DEFAULT NULL
"REMARKS"            20 DEFAULT NULL
INFILE *
COMPRESSED
SEPARATOR '|'
DELIMITER '' ""","""
CHAR|1|254|'|'|max length|1|1|3|?|0|?|CHAR|?|?|1|?|?|?|?
DECIMAL|2|38|?|?|precision,scale|1|0|2|0|0|?|NUMERIC|0|38|2|?|10|?|?
FIXED|3|38|?|?|precision,scale|1|0|2|0|0|?|DECIMAL|0|38|3|?|10|?|?
INTEGER|4|10|?|?|?|1|0|2|0|0|?|INTEGER|?|?|4|?|10|?|?
SMALLINT|5|5|?|?|?|1|0|2|0|0|?|SMALLINT|?|?|5|?|10|?|?
FLOAT|6|15|?|?|?|1|0|2|0|0|?|FLOAT|?|?|6|?|2|?|?
REAL|7|15|?|?|?|1|0|2|0|0|?|REAL|?|?|7|?|2|?|?
DOUBLE PRECISION|8|16|?|?|?|1|0|2|0|0|?|DOUBLE PRECISION|?|?|8|?|2|?|?
DATE|9|10|'|'|?|1|0|2|?|0|?|DATE|?|?|9|?|?|?|?
TIME|10|8|'|'|?|1|0|2|?|0|?|TIME|?|?|10|?|?|?|?
TIMESTAMP|11|26|'|'|?|1|0|2|?|0|?|TIMESTAMP|?|?|11|?|?|?|?
VARCHAR|12|4000|'|'|max length|1|1|3|?|0|?|VARCHAR|?|?|12|?|?|?|?
LONG|-1|2147483647|'|'|?|1|1|0|?|0|?|LONG|?|?|-1|?|?|?|?
CHAR() BYTE|-2|254|X'|'|max length|1|0|2|?|0|?|BINARY|?|?|-2|?|?|?|?
VARCHAR() BYTE|-3|4000|X'|'|max length|1|0|2|?|0|?|VARBINARY|?|?|-3|?|?|?|?
LONG BYTE|-4|2147483647|X'|'|?|1|0|0|?|0|?|LONG BYTE|?|?|-4|?|?|?|?
BOOLEAN|-7|1|?|?|?|1|0|2|?|0|?|BOOLEAN|?|?|-7|?|?|?|?
""")


    if sqlOK (session, """
            SELECT DESCRIPTION
            FROM SYSDD.XPARAMETERS
            WHERE DESCRIPTION = '_UNICODE'
            AND "VALUE" = 'YES'"""):
        dataLoad (session, """
DATALOAD TABLE SYSODBCTYPES
"TYPE_NAME"           1
"DATA_TYPE"           2
"PRECISION"           3 DEFAULT NULL
"LITERAL_PREFIX"      4 DEFAULT NULL
"LITERAL_SUFFIX"      5 DEFAULT NULL
"CREATE_PARAMS"       6 DEFAULT NULL
"NULLABLE"            7
"CASE_SENSITIVE"      8
"SEARCHABLE"          9
"UNSIGNED_ATTRIBUTE" 10 DEFAULT NULL
"MONEY"              11
"AUTO_INCREMENT"     12 DEFAULT NULL
"LOCAL_TYPE_NAME"    13 DEFAULT NULL
"MINIMUM_SCALE"      14 DEFAULT NULL
"MAXIMUM_SCALE"      15 DEFAULT NULL
"SQL_DATA_TYPE"      16
"SQL_DATETIME_SUB"   17 DEFAULT NULL
"NUM_PREC_RADIX"     18 DEFAULT NULL
"INTERVAL_PRECISION" 19 DEFAULT NULL
"REMARKS"            20 DEFAULT NULL
INFILE *
COMPRESSED SEPARATOR '|' DELIMITER '' ""","""
CHAR() UNICODE|-95|127|'|'|max length|1|1|3|?|0|?|UNICODE|?|?|-95|?|?|?|?
VARCHAR() UNICODE|-96|2000|'|'|max length|1|1|3|?|0|?|UNICODE VARCHAR|?|?|-96|?|?|?|?
LONG UNICODE|-97|1073741823|?|?|?|1|0|2|?|0|?|LONG UNICODE|?|?|-97|?|?|?|?
""")

    # ********************************
    #  View SYSODBCTABLES
    # ********************************

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        stopIfSqlNotOK (session, """
            CREATE OR REPLACE VIEW SYSODBCTABLES
                  (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME,TABLE_TYPE,  REMARKS)
                AS SELECT
                   NULL, OWNER, TABLENAME,
                   DECODE(TYPE,'SYSTEM',UNICODE('SYSTEM TABLE'),TYPE),
                   NULL
                FROM "SYSDD".TABLES
                INTERNAL""")

    else:
        stopIfSqlNotOK (session, """
            CREATE OR REPLACE VIEW SYSODBCTABLES
                  (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME,TABLE_TYPE,  REMARKS)
                AS SELECT
                   NULL, OWNER, TABLENAME, DECODE(TYPE,'SYSTEM',
                   'SYSTEM TABLE',TYPE), NULL
                FROM "SYSDD".TABLES
                INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCTABLES TO PUBLIC')


    # ********************************
    #  View SYSODBCCOLUMNS
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCCOLUMNS
              (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, COLUMN_NAME,
               DATA_TYPE, TYPE_NAME, PRECISION, "LENGTH", SCALE, RADIX,
               NULLABLE, REMARKS, POS, CODETYPE, KEY_SEQ)
            AS SELECT
                   NULL, OWNER, TABLENAME, COLUMNNAME, NUM(99), DATATYPE, PRECISION,
                   LEN, "DEC", RADIX, NULLABLE, NULL, COLUMNNO, CODE, KEY_SEQ
            FROM SYSDD.ODBC_COLUMNS
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCCOLUMNS TO PUBLIC')


    # ********************************
    #  View SYSODBCINDEXSTAT
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCINDEXSTAT
            AS SELECT
               OWNER, TABLENAME, INDEXNAME, COLUMNNAME, ROWS, PAGECOUNT
            FROM SYSDD.ODBC_INDEXSTATS
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCINDEXSTAT TO PUBLIC')


    # ********************************
    #  View SYSODBCTABLESTAT
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCTABLESTAT
            AS SELECT
               OWNER, TABLENAME, ROWS, PAGECOUNT
            FROM SYSDD.ODBC_TABLESTATS
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCTABLESTAT TO PUBLIC')


    # ********************************
    #  View SYSODBCINDEXES
    # ********************************

    rc = sqlRC (session, """SELECT DESCRIPTION
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = '_UNICODE'
        AND "VALUE" = 'YES'""")

    if rc == 0:

        stopIfSqlNotOK (session, """
            CREATE OR REPLACE VIEW SYSODBCINDEXES
                  (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, NON_UNIQUE,
                   INDEX_QUALIFIER, INDEX_NAME, TYPE, SEQ_IN_INDEX, COLUMN_NAME,
                   COLLATION, CARDINALITY, PAGES, FILTER_CONDITION, INDEX_TYPE)
                    AS SELECT
                   NULL, OWNER, TABLENAME, NUM(DECODE(TYPE, 'UNIQUE', 0, 1)),
                   DECODE(INDEXNAME, 'SYSPRIMARYKEYINDEX', UNICODE(' '), NULL),
                   INDEXNAME, 3, COLUMNNO, COLUMNNAME, SUBSTR(SORT, 1, 1),
                   NUM(NULL), NUM(NULL), NULL, TYPE
                    FROM SYSDD.ODBC_INDEXES
                INTERNAL""")

    else:
        stopIfSqlNotOK (session, """
            CREATE OR REPLACE VIEW SYSODBCINDEXES
                  (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, NON_UNIQUE,
                   INDEX_QUALIFIER, INDEX_NAME, TYPE, SEQ_IN_INDEX, COLUMN_NAME,
                   COLLATION, CARDINALITY, PAGES, FILTER_CONDITION, INDEX_TYPE)
                    AS SELECT
                   NULL, OWNER, TABLENAME, NUM(DECODE(TYPE, 'UNIQUE', 0, 1)),
                   DECODE(INDEXNAME, 'SYSPRIMARYKEYINDEX', ' ', NULL),
                   INDEXNAME, 3, COLUMNNO, COLUMNNAME, SUBSTR(SORT, 1, 1),
                   NUM(NULL), NUM(NULL), NULL, TYPE
                    FROM SYSDD.ODBC_INDEXES
                INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCINDEXES TO PUBLIC')


    # ********************************
    #  View SYSODBCFOREIGNKEYS
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCFOREIGNKEYS
              (PKTABLE_QUALIFIER, PKTABLE_OWNER, PKTABLE_NAME, PKCOLUMN_NAME,
               FKTABLE_QUALIFIER, FKTABLE_OWNER, FKTABLE_NAME, FKCOLUMN_NAME,
               KEY_SEQ, UPDATE_RULE, DELETE_RULE, FK_NAME, PK_NAME)
            AS SELECT
               NULL, REFOWNER, REFTABLENAME, REFCOLUMNNAME, NULL, OWNER,
               TABLENAME, COLUMNNAME, KEYCOLUMNNO, NULL, NUM(DECODE(RULE,
               'DELETE CASCADE',0,'DELETE RESTRICT',1,'DELETE SET NULL',2,2)),
               REFNAME, NULL
            FROM SYSDD.FOREIGN_KEYS
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCFOREIGNKEYS TO PUBLIC')


    # ********************************
    #  View SYSODBCTABLEPRIVILEGES
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCTABLEPRIVILEGES
              (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, GRANTOR, GRANTEE,
               PRIVILEGE, IS_GRANTABLE)
            AS SELECT
               NULL, OWNER, NAME1, GRANTOR, GRANTEE, DECODE(SUBSTR(PRIVILEGES,
               LENGTH(PRIVILEGES),1),'+',SUBSTR(PRIVILEGES,1,LENGTH(PRIVILEGES)-1),
               PRIVILEGES), DECODE(SUBSTR(PRIVILEGES,LENGTH(PRIVILEGES),1),'+',
               'YES','NO')
                FROM SYSDD.NEW_PRIVILEGES
                WHERE
               NAME2 IS NULL AND TYPE NOT IN ('SEQUENCE', 'DBPROC')
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCTABLEPRIVILEGES TO PUBLIC')


    # ********************************
    #  View SYSODBCCOLUMNPRIVILEGES
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCCOLUMNPRIVILEGES
              (TABLE_QUALIFIER, TABLE_OWNER, TABLE_NAME, COLUMN_NAME, GRANTOR,
               GRANTEE, PRIVILEGE, IS_GRANTABLE)
            AS SELECT
                   NULL, C.OWNER, C.TABLENAME, C.COLUMNNAME, P.GRANTOR, P.GRANTEE,
                   ASCII (DECODE (SUBSTR(P.PRIVILEGES, LENGTH(P.PRIVILEGES), 1), '+',
                   SUBSTR (P.PRIVILEGES, 1, LENGTH(P.PRIVILEGES) - 1), P.PRIVILEGES)),
                   ASCII (DECODE (SUBSTR(P.PRIVILEGES, LENGTH(P.PRIVILEGES), 1), '+',
                   'YES', 'NO'))
                FROM  SYSDD.NEW_PRIVILEGES P, SYSDD.COLUMNS C
                WHERE
               P.TYPE NOT IN ('SEQUENCE', 'DBPROC')        AND
                   C.OWNER = P.OWNER AND C.TABLENAME = P.NAME1 AND
                   (C.COLUMNNAME = P.NAME2 OR P.NAME2 IS NULL)
                INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCCOLUMNPRIVILEGES TO PUBLIC')


    # ********************************
    #  View SYSODBCPROCEDURES
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCPROCEDURES
              (PROCEDURE_QUALIFIER, PROCEDURE_OWNER, PROCEDURE_NAME,
               NUM_INPUT_PARAMS, NUM_OUTPUT_PARAMS, NUM_RESULT_SETS, REMARKS,
               PROCEDURE_TYPE)
            AS SELECT
               NULL, OWNER, DBPROCEDURE, NULL, NULL, NULL, COMMENT, NUM(1)
            FROM SYSDD.DBPROCEDURES
            WHERE
               DBPROCEDURE <> ' '
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCPROCEDURES TO PUBLIC')


    # ********************************
    #  View SYSODBCPROCCOLUMNS
    # ********************************

    stopIfSqlNotOK (session, """
        CREATE OR REPLACE VIEW SYSODBCPROCCOLUMNS
              (PROCEDURE_QUALIFIER, PROCEDURE_OWNER,PROCEDURE_NAME, COLUMN_NAME,
               COLUMN_TYPE, DATA_TYPE, TYPE_NAME, PRECISION, "LENGTH", SCALE,
               RADIX, NULLABLE, REMARKS, CODETYPE, PARAM_NO)
            AS SELECT
               NULL, OWNER, DBPROCEDURE, PARAMETERNAME, NUM(DECODE("IN/OUT-TYPE",
               'IN',1,'IN/OUT',2,'   OUT',4,0)), NUM(99), DATATYPE, LEN,
               NUM(DECODE(DATATYPE,'FIXED',LEN+2,'FLOAT',DECODE((LEN DIV 8+1)*
               4,4,4,8,8,12,8),'INTEGER',4,'SMALLINT',2,LEN)), "DEC", DECODE(
               DATATYPE,'FIXED',10,'FLOAT',10,'INTEGER',10,'SMALLINT',10,NULL),
               NUM(1), NULL, CODE, PARAM_NO
            FROM SYSDD.DBPROCPARAMETERS
            WHERE
               DBPROCEDURE <> ' '
            INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON SYSODBCPROCCOLUMNS TO PUBLIC')


    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

    # End of Install


if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)

