# =====================================================
# @(#) INFO.py                       7.2.01  1999-10-06
# =====================================================
#
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

from installib import *

def install (session,options):
    """Installing messages and help
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

    if existsTable (session, "MESSAGES"):
        if (options.migrate):
            stopIfSqlNotOK  (session, 'ALTER TABLE MESSAGES MODIFY (MSGTEXT SYSMSGTEXT)')

    else:
        stopIfSqlNotOK (session,
                """CREATE TABLE MESSAGES
                (MSGNO    FIXED(5,0),
                LANGUAGE  CHAR(3)     ASCII,
                MSGTEXT   SYSMSGTEXT,
                CONSTRAINT MESSAGES_PK PRIMARY KEY(MSGNO,LANGUAGE))
                INTERNAL""")

    stopIfSqlNotOK (session, 'GRANT SELECT ON MESSAGES TO PUBLIC')

#   SAY ------ Loading messages ...


    rc = sqlRC (session, """DELETE MESSAGES WHERE LANGUAGE = UPPER('%s')""" % options.dblng)

    loaderCmd (session,
        """DATALOAD
        TABLE MESSAGES IF POS 1-2 <> '++'
               "LANGUAGE"      1-3
               MSGNO           5-10
               MSGTEXT        12-91
               INFILE 'env/%s/SQLMESS.%s'
               FORMATTED""" % (options.lng,options.lng))

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)

