# =====================================================
# @(#) CNR3DATA.py                   7.2.01  1999-11-11
# =====================================================
#
#
#    ========== licence begin LGPL
#    Copyright (C) 2000 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#

from installib import *
from CNR3TAB   import *

def install (session,options):
    """Installing backup history
    """

    loaderCmd (session, 'INSTALLATION ON')

    loaderCmd (session, 'AUTOCOMMIT OFF')

#
#   Create tables definition in CNR3TAB
#
    include (session,options,'CNR3TAB')

    print options.fdir

    if existsTable (session, "CNHIST"):

        loaderCmd (session,
            """DATALOAD
            TABLE CNHIST
            IGNORE DUPLICATES
            CMD_ID             1-12
            LABEL              14-22
            ACTION             24-32
            START_LPNO_DATE    34-43
            START_LPNO_TIME    45-52
            STOP_LPNO_DATE     54-63
            STOP_LPNO_TIME     65-72
            BEGIN_DATE         74-83
            BEGIN_TIME         85-92
            END_DATE           94-103
            END_TIME           105-112
            START_LPNO         114-123 DEFAULT NULL
            STOP_LPNO          125-134 DEFAULT NULL
            LOGREQUESTED       136-138
            MEDIANAME          140-147
            PAGECOUNT          205-214 DEFAULT NULL
            VOLUMES            216-225 DEFAULT NULL
            RETCODE            227-236 DEFAULT NULL
            RETTEXT            238-277
         INFILE '%s/dbm.knl'
         NULL ' '
         DATE 'YYYY-MM-DD'
         TIME 'HH:MM:SS'
         FORMATTED""" %options.fdir )

    if existsTable (session, "CNREPRT"):

#
#   PTS: 1112051
#
        loaderCmd (session,
            """DATALOAD
               TABLE CNREPRT
               IF  (POS 1-4 <> 'Date')
               AND (POS 1-4 <> '    ')
               AND (POS 1-4 <> '----')
               AND (POS 1-4 <> '====')
               IGNORE DUPLICATES
               REP_DATE        1-10
               REP_TIME       12-19
               CMD_ID         21-32
               LINENO         34-37
               CMDTYP         41-43
               LINE           45-299
               INFILE '%s/dbm.utl'
               FORMATTED""" %options.fdir)

    loaderCmd (session, 'COMMIT')

    loaderCmd (session, 'INSTALLATION OFF')

if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)





