from installib import *

import sys
import os
import string
import dbm

def install (session, options):
    """Installing APPS
    """

    instroot = getInstroot (options.db)
    sapuser = getSAPUser (options.sapuser)

    loaderCmd (session, 'INSTALLATION ON')
    loaderCmd (session, 'AUTOCOMMIT OFF')

    stopIfSqlNotErr (session, -6006,
        'CREATE USER %s PASSWORD %s DBA NOT EXCLUSIVE' %
        (sapuser[0], sapuser[1]))

    sqlOK (session, "COMMIT")

    allPackages = []

    rc = sqlRC (session,
        """SELECT "VALUE"
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = 'INSTANCE_TYPE'
        AND "VALUE" = 'LVC'""")

    if rc == 0:
        allPackages.append ('dbpinstall')
        allPackages.append ('SAPAPO')
        allPackages.append ('SAPATP')
        allPackages.append ('SAPRPM')
        allPackages.append ('SAPTS')
        allPackages.append ('SAPREP')
        allPackages.append ('SAPSEA')
        allPackages.append ('SAPSIM')
        allPackages.append ('SAPTEST')

    rc = sqlRC (session,
        """SELECT "VALUE"
        FROM SYSDD.XPARAMETERS
        WHERE DESCRIPTION = 'INSTANCE_TYPE'
        AND "VALUE" = 'BW'""")

    if rc == 0:
        allPackages.append ('dbpinstall')
        allPackages.append ('sphsapdb')

    loaderCmd (session, 'USE USER %s %s' % (sapuser[0], sapuser[1]))
    print (string.upper (sapuser[0]))

    for package in allPackages:
        string.strip (package)
        (lstFilename, libFilename) = getFilename (instroot, package)

        if lstFilename:
            print '  ' + package

            createPackage (session, package, libFilename)

            for proc in open (lstFilename, 'rt').readlines ():
                proc = string.strip (proc)

                if re.match ('^#', proc):
                    continue

                if re.match ('^\W*$', proc):
                    continue

                print '    ' + re.match ('^(\w+)', proc).group (1)
                createDBProc (session, package, proc)

    sqlOK (session, "COMMIT")

    switchToDefaultUser (session, options)

def getSAPUser (usrpwd):
    return re.split (',', usrpwd)

def getInstroot (dbname):
    if os.name == 'posix' and os.uname()[0] == 'OSF1':
        return re.sub (os.sep + '\w+' + os.sep + '[\w\.]+$', '', sys.argv[0])

    for line in re.split ('\n', dbm.DBM ('', dbname).cmd ('dbm_version')):
        line = string.strip (line)

        if not re.match ('^INSTROOT\s+=\s+\S+$', line):
            continue

        instroot = re.sub ('^INSTROOT\s+=\s+', '', line)
        string.strip (instroot)
        return instroot

    return

def getDllExt ():
    if os.name != 'posix':
        return '.dll'

    if os.uname()[0] == 'HP-UX':
        return '.sl'

    return '.so'

def getFilename (instroot, package):
    ext = getDllExt ()
    libdirs = [
        ('sap', ''),
        ('lib', ''),
        ('lib', 'lib64'),
        ('pgm', ''),
        ('pgm', 'pgm64'),
    ]
    for prefix in ['', 'lib']:
        package = prefix + package
        lstFilename = os.path.join (instroot, 'sap', package + '.lst')
        if os.access (lstFilename, os.R_OK):
            for dir1, dir2 in libdirs:
                libFilename = os.path.join (instroot, dir1, dir2, package + ext)
                if os.access (libFilename, os.R_OK):
                    return (lstFilename, libFilename)
    return ('', '')

def createPackage (session, package, libFilename):
    stopIfSqlNotErr (session, -4024, 'DROP PACKAGE %s' % package)

    stopIfSqlNotOK (session,
    """CREATE PACKAGE %s FILE '%s'
    INPROC""" % (package, libFilename))

def createDBProc (session, package, proc):
    mode = re.split ('\W+', proc)
    proc = mode.pop (0)

    if not mode:
        mode = 'INPROC'

    elif re.match ('NOWAIT', mode.pop (0)):
         mode = 'INPROC'

    else:
         mode = mode.pop(0)

    stopIfSqlNotOK (session,
        """CREATE DBPROC %s IN %s EXECUTE %s""" % (proc, package, mode))

if __name__ == '__main__':
    connectAndInstall (install, install.__doc__)
