#!/usr/bin/env python
#
#    ========== licence begin LGPL
#    Copyright (C) 2002 SAP AG
#
#    This library is free software; you can redistribute it and/or
#    modify it under the terms of the GNU Lesser General Public
#    License as published by the Free Software Foundation; either
#    version 2.1 of the License, or (at your option) any later version.
#
#    This library is distributed in the hope that it will be useful,
#    but WITHOUT ANY WARRANTY; without even the implied warranty of
#    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#    Lesser General Public License for more details.
#
#    You should have received a copy of the GNU Lesser General Public
#    License along with this library; if not, write to the Free Software
#    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#    ========== licence end
#


import sys
import sapdb.sql
import demodbData

def sayHello (session):
    cursor = session.sql ("select 'Hello, SAP DB' from dual")
    row = cursor.next ()
    # row is a tuple with one element
    (result,) = row
    print result

def createSession (username, password, dbname, host):
    session = sapdb.sql.connect (username, password, dbname, host)
    return session

def main ():
    username, password, dbname, host = demodbData.parseUserArgs (sys.argv [1:])
    session = createSession (username, password, dbname, host)
    sayHello (session)
    session.commit ()  # not necessary for a SELECT, but good style anyway

if __name__ == "__main__":
    main ()
