/*  SAP DB ODBC example, 2000-09-26

    Progname      odbcexample.c

    Build:        make odbcexample

    Description:  Creates a table, inserts some values and read them again

    Note:         For convinience, not all return codes of the ODBC functions
                  are evaluated.


    ========== licence begin LGPL
    Copyright (C) 2002 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end

*/

#include <stdio.h>
#include <string.h>
#include "WINDOWS.H"
#include "sql.h"
#include "sqlext.h"

#define MAX_NAME_LEN 50
#define MAX_STMT_LEN 300

int printSQLError (SQLHDBC hdbc, SQLHSTMT hstmt);

int main (int argc, char **argv)
{
  SQLHENV   henv;
  SQLHDBC   hdbc;
  SQLHSTMT  hstmt;

  UCHAR   name[MAX_NAME_LEN + 1];
  UCHAR   create[MAX_STMT_LEN];
  UCHAR   insert[MAX_STMT_LEN];
  UCHAR   select[MAX_STMT_LEN];
  UCHAR   server[MAX_STMT_LEN];
  UCHAR   *user, *password;
  SDWORD  id;
  SDWORD  nameLen;
  RETCODE rc;

  if (argc != 5)
    {
    puts("usage: odbcexample <servernode> <database> <user> <password>");
    puts("\nE.g.   odbcexample localhost LINV72 test test\n");
    return (0);
    }

  sprintf (server, "%s:%s", argv[1], argv[2]);
  user     = argv[3];
  password = argv[4];

/* Allocate environment, connection, and statement handle  */
  SQLAllocHandle (SQL_HANDLE_ENV, SQL_NULL_HANDLE, &henv);
  SQLAllocHandle (SQL_HANDLE_DBC, henv, &hdbc);

/* Connect to data source                                  */
  printf ("Connect to data base %s on host %s as user %s (%s)\n",
	  argv[2], argv[1], argv[3], argv[4]);
  rc = SQLConnect (hdbc, server, SQL_NTS, user, SQL_NTS, password, SQL_NTS);
  if (rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO)
    return (printSQLError (hdbc, SQL_NULL_HSTMT));
  SQLAllocHandle (SQL_HANDLE_STMT, hdbc, &hstmt);

/* CREATE TABLE MASTERS (ID integer, NAME varchar(50))      */
  strcpy (create, "CREATE TABLE MASTERS (ID INTEGER, NAME VARCHAR(50))");
  rc = SQLExecDirect (hstmt, create, SQL_NTS);
  if (rc != SQL_SUCCESS && rc != SQL_SUCCESS_WITH_INFO)
    return (printSQLError (hdbc, hstmt));


/* Prepare the insertion and bind parameters.                            */
/* Repeat assignment of parameter values and execution of the statement */
  strcpy (insert, "INSERT INTO MASTERS VALUES (?, ?)");
  if (SQLPrepare (hstmt, insert, SQL_NTS) != SQL_SUCCESS)
    return (printSQLError (hdbc, hstmt));

  SQLSetParam(hstmt, 1, SQL_C_LONG, SQL_INTEGER, 0, 0, &id, NULL);
  SQLSetParam(hstmt, 2, SQL_C_CHAR, SQL_VARCHAR, MAX_NAME_LEN, 0, name, NULL);

  id = 1; strcpy (name, "Leibnitz");
  if (SQLExecute (hstmt) != SQL_SUCCESS)
    return(printSQLError (hdbc, hstmt));

  id = 2; strcpy (name, "Babbage");
  if (SQLExecute (hstmt) != SQL_SUCCESS)
    return(printSQLError (hdbc, hstmt));

  id = 3; strcpy (name, "Turing");
  if (SQLExecute (hstmt) != SQL_SUCCESS)
    return(printSQLError (hdbc, hstmt));

  id = 4; strcpy (name, "Zuse");
  if (SQLExecute (hstmt) != SQL_SUCCESS)
    return(printSQLError (hdbc, hstmt));


/* Select from table */
  strcpy (select, "SELECT ID, NAME FROM MASTERS");
  if (SQLExecDirect (hstmt, select, SQL_NTS) != SQL_SUCCESS)
    return (printSQLError (hdbc, hstmt));

/* Bind columns of the result set. */
  SQLBindCol (hstmt, 1, SQL_C_LONG, &id, 0, NULL);
  SQLBindCol (hstmt, 2, SQL_C_CHAR, name, (SDWORD)sizeof(name), &nameLen);

/* fetch all rows and print them */
  while (1)
    {
    rc = SQLFetch (hstmt);
    if (rc == SQL_SUCCESS || rc == SQL_SUCCESS_WITH_INFO)  
      printf ("Id = %ld\t Name = %s\n", id, name);
    else if (rc == SQL_NO_DATA)
      break;
    else
      {
      printSQLError (hdbc, hstmt);
      break;
      }
    }


/* Disconnect from the data source and free all handles. */
  SQLDisconnect (hdbc);
  SQLFreeHandle (SQL_HANDLE_STMT, hstmt);
  SQLFreeHandle (SQL_HANDLE_DBC,  hdbc);
  SQLFreeHandle (SQL_HANDLE_ENV,  henv);

  return (0);
}

int printSQLError (SQLHDBC hdbc, SQLHSTMT hstmt)
{
   UCHAR  sqlstate[10];
   SDWORD sqlcode;
   UCHAR  errortxt[MAX_STMT_LEN+1];
   SWORD  usederrortxt;

   SQLError (SQL_NULL_HENV, hdbc, hstmt, sqlstate, &sqlcode, errortxt,
	     MAX_STMT_LEN, &usederrortxt);

   printf (" SQL state: %s\n", sqlstate);
   printf (" SQL code:  %ld\n", sqlcode);
   printf (" SQL Errortext:\n%s\n\n", errortxt);
   return (0);
}
