/*


    ========== licence begin LGPL
    Copyright (C) 2002 SAP AG

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Lesser General Public
    License as published by the Free Software Foundation; either
    version 2.1 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Lesser General Public License for more details.

    You should have received a copy of the GNU Lesser General Public
    License along with this library; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
    ========== licence end


*/

import java.sql.*;

/**
 *
 */
public class HelloSAPDB
{
    /**
     * creates a new HelloSAPDB
     */
    private
    HelloSAPDB ()
    {
    }
    /**
     * used when called form the command line
     */
    public static void main (String [] args)
    throws SQLException, ClassNotFoundException
    {
        DemodbData userInfo = DemodbData.parseUserArgs (args);
        /*
         * load driver and connect
         */
        Class.forName ("com.sap.dbtech.jdbc.DriverSapDB");
        String url = "jdbc:sapdb://"
            + userInfo.host + "/"
            + userInfo.dbname;

        Connection connection = DriverManager.getConnection (url,
            userInfo.username, userInfo.password);
        /*
         * execute query
         */
        Statement stmt = connection.createStatement ();
        ResultSet cursor = stmt.executeQuery (
            "select 'Hello, SAP DB' from dual");
        /*
         * fetch values
         */
        int fetchCount = 0;
        while (cursor.next ()) {
            String result = cursor.getString (1);
            System.out.println (result);
            ++fetchCount;
        }
        if (fetchCount == 0) {
            System.out.println ("unexpectoed end of cursor");
        }
    }
}
