package com.sap.caf.core.appsrv.currencyconversion;

import com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocal;
import com.sap.caf.core.besrv.exchangerate.ExchangeRateServiceLocalHome;
import com.sap.caf.core.utils.HomeFactory;

public interface CurrencyConversionLocal extends com.sap.caf.rt.srv.IService {

    /**
     * Business Methods
     */
    /**
     * Convert Currency
     * @param rateType Attribute.shortText
     * @param currencyFrom Attribute.shortText
     * @param currencyTo Attribute.shortText
     * @param date Attribute.shortText
     * @exception com.sap.caf.rt.exception.CAFFindException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.ArrayList convertCurrency(java.lang.String rateType, java.lang.String currencyFrom, java.lang.String currencyTo, java.sql.Date date) throws com.sap.caf.rt.exception.CAFFindException;

    /**
     * Convert Currency for today
     * @param currencyFrom Attribute.shortText
     * @param currencyTo Attribute.shortText
     * @exception com.sap.caf.rt.exception.CAFFindException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.ArrayList convertCurrencyForToday(java.lang.String currencyFrom, java.lang.String currencyTo) throws com.sap.caf.rt.exception.CAFFindException;

    /**
     * Convert Currency with structure parameters
     * @param amount Attribute.shortText
     * @param currencyTarget Attribute.shortText
     * @param date Attribute.shortText
     * @param rateType Attribute.shortText
     * @exception com.sap.caf.rt.exception.CAFFindException FaultMessage.shortText
     * @return Attribute.shortText
     */
    public java.util.ArrayList convertCurrencyWithStructure(com.sap.caf.core.appsrv.datatypes.Amount amount, java.lang.String currencyTarget, java.sql.Date date, java.lang.String rateType) throws com.sap.caf.rt.exception.CAFFindException;

}