/*
 * Olap_10.java
 *
 * Copyright 2004-2005 by SAP AG. All Rights Reserved.
 * SAP, R/3, mySAP, mySAP.com, xApps, xApp, SAP NetWeaver, and other SAP 
 * products and services mentioned herein as well as their respective logos 
 * are trademarks or registered trademarks of SAP AG in Germany and in several 
 * other countries all over the world. All other product and service names 
 * mentioned are the trademarks of their respective companies. Data contained 
 * in this document serves informational purposes only. National product 
 * specifications may vary.
 *
 * These materials are subject to change without notice. These materials are 
 * provided by SAP AG and its affiliated companies ("SAP Group") for 
 * informational purposes only, without representation or warranty of any kind, 
 * and SAP Group shall not be liable for errors or omissions with respect to 
 * the materials. The only warranties for SAP Group products and services are 
 * those that are set forth in the express warranty statements accompanying 
 * such products and services, if any. Nothing herein should be construed as 
 * constituting an additional warranty.
 */
package com.sap.ip.bi.sdk.samples;

import java.io.IOException;
import java.io.PrintWriter;

import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.sap.exception.IBaseException;
import com.sap.ip.bi.sdk.dac.connector.IBIConnection;
import com.sap.ip.bi.sdk.dac.connector.IBIOlap;
import com.sap.ip.bi.sdk.dac.olap.query.IBICommandProcessor;
import com.sap.ip.bi.sdk.dac.olap.query.main.IBIQuery;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBIRelationalOperatorTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.types.IBISapRangeSignTypeEnum;
import com.sap.ip.bi.sdk.dac.olap.query.var.IBISapMemberVariable;
import com.sap.ip.bi.sdk.samples.servlet.MinimalServletContainer;

/**
 * SAP variable retrieval and editing -
 *
 * Illustrates retrieval of and effect of editing an SAP variable. Sets a 
 * value for an optional SAP variable, renders the result of the default query 
 * into a table, searches for a specific optional SAP variable using the OLAP 
 * object finder, changes its value, and then re-renders the result into a 
 * new table for comparison.
 * 
 * View the HTML rendered by this servlet in the following file:
 * [SDK archive]/docs/examples/olap_10.result.html
 *
 * @author  SAP
 * @version 3.50 SP2
 * @since 3.50 SP2
 */
public class Olap_10 extends HttpServlet {
  private static final String CONTENT_TYPE = "text/html";

  public void init(ServletConfig config) throws ServletException {
    super.init(config);
  }

  public void doGet(HttpServletRequest request, HttpServletResponse response)
    throws ServletException, IOException {

    response.setContentType(CONTENT_TYPE);
    PrintWriter out = response.getWriter();

    out.println(Helpers.getDocTypeDefinition());
    out.println("<html>");
    out.println("<head><title>Olap_10</title>");
    out.println(Helpers.getStyleSheetDefinition());
    out.println("</head><body>");

    try {
      // ********************************************************
      // Connect to data source
      // ********************************************************
      IBIConnection connection = Helpers.connectToXMLADatasource(out);

      // ********************************************************
      // Get OLAP interface and Retrieve metadata.
      // ********************************************************
      IBIOlap olap = connection.getOlap();

      Helpers.SampleMetaDataBW sampleMetaData =
        Helpers.getSampleMetaDataBW(connection);

      // ********************************************************
      // Create query and get command processor.
      // ********************************************************
      IBIQuery query = olap.createQuery(sampleMetaData.cube2);
      IBICommandProcessor commandProcessor = query.getCommandProcessor();

      // ********************************************************
      // find variable [0D_SA_OR]
      // ********************************************************
      IBISapMemberVariable variable = (IBISapMemberVariable) 
        olap.getObjectFinder().findSAPVariableFirst(
          sampleMetaData.cube2, "[0D_SA_OR]");

      // ********************************************************
      // set variable sales organization [0D_SA_OR] to 
      // value New York
      // ********************************************************
      commandProcessor.clearSapVariableValue(variable);
      commandProcessor.addSapVariableValue(
        variable,
        IBISapRangeSignTypeEnum.INCLUDING,
        IBIRelationalOperatorTypeEnum.EQUAL,
        sampleMetaData.salesOrgNewYork2, 
        null);

      // ********************************************************
      // render the result set 
      // ********************************************************
      Helpers.renderQueryAndDataset(out, query);

      // ********************************************************
      // set variable sales organization [0D_SA_OR] to 
      // value San Francisco
      // ********************************************************
      commandProcessor.clearSapVariableValue(variable);
      commandProcessor.addSapVariableValue(
        variable,
        IBISapRangeSignTypeEnum.INCLUDING,
        IBIRelationalOperatorTypeEnum.EQUAL,
        sampleMetaData.salesOrgSanFrancisco2, 
        null);

      // ********************************************************
      // render the result set again
      // ********************************************************
      Helpers.renderQueryAndDataset(out, query);
    }

    // Catch errors
    catch (Exception e) {
      // $JL-EXC$
      e.printStackTrace();
      if (e instanceof IBaseException)
        out.println(
          "Error: " + ((IBaseException) e).getNestedLocalizedMessage());
      else
        out.println("Error: " + e.getMessage());
    }

    out.println("</body>");
    out.println("</html>");
  }

  public void destroy() {
  }

  public static void main(String[] args) {

    if (args.length == 1) {
      MinimalServletContainer.executeServlet(new Olap_10(), args[0]);
    } else {
      MinimalServletContainer.executeServlet(new Olap_10(), System.out);
    }
  }

}
